/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.dumpcheck.WikipediaSentenceSource;

class WikipediaSentenceExtractor {
    WikipediaSentenceExtractor() {
    }

    private void extract(Language language, String xmlDumpPath) throws IOException, CompressorException {
        try (FileInputStream fis = new FileInputStream(xmlDumpPath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             CompressorInputStream input = new CompressorStreamFactory().createCompressorInputStream((InputStream)bis);){
            int sentenceCount = 0;
            WikipediaSentenceSource source = new WikipediaSentenceSource((InputStream)input, language);
            while (source.hasNext()) {
                String sentence = source.next().getText();
                if (this.skipSentence(sentence)) continue;
                System.out.println(sentence);
                if (++sentenceCount % 1000 != 0) continue;
                System.err.println("Exporting sentence #" + sentenceCount + "...");
            }
        }
    }

    private boolean skipSentence(String sentence) {
        return sentence.trim().length() == 0 || Character.isLowerCase(sentence.trim().charAt(0));
    }

    public static void main(String[] args) throws IOException, CompressorException {
        if (args.length != 2) {
            System.out.println("Usage: " + WikipediaSentenceExtractor.class.getSimpleName() + " <langCode> <wikipediaXmlDump>");
            System.exit(1);
        }
        WikipediaSentenceExtractor extractor = new WikipediaSentenceExtractor();
        extractor.extract(Languages.getLanguageForShortCode((String)args[0]), args[1]);
    }
}

