/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.atom.StoredWikipediaRuleMatch;
import org.languagetool.dev.wikipedia.atom.WikipediaRuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;

class MatchDatabase {
    private final Connection conn;

    MatchDatabase(String dbUrl, String dbUser, String dbPassword) {
        try {
            this.conn = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get database connection to " + dbUrl, e);
        }
    }

    void updateRuleMatchPingDate(Language language, Date date) {
        this.updateRuleMatchDate("pings", language, date);
    }

    void updateRuleMatchCheckDate(Language language, Date date) {
        this.updateRuleMatchDate("feed_checks", language, date);
    }

    private void updateRuleMatchDate(String tableName, Language language, Date date) {
        block26: {
            String updateSql = "UPDATE " + tableName + " SET check_date = ? WHERE language_code = ?";
            try (PreparedStatement updateSt = this.conn.prepareStatement(updateSql);){
                updateSt.setTimestamp(1, new Timestamp(date.getTime()));
                updateSt.setString(2, language.getShortCode());
                int affected = updateSt.executeUpdate();
                if (affected != 0) break block26;
                String insertSql = "INSERT INTO " + tableName + " (language_code, check_date) VALUES (?, ?)";
                try (PreparedStatement insertSt = this.conn.prepareStatement(insertSql);){
                    insertSt.setString(1, language.getShortCode());
                    insertSt.setTimestamp(2, new Timestamp(date.getTime()));
                    insertSt.execute();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not store date for " + language + " to database, table " + tableName, e);
            }
        }
    }

    void add(WikipediaRuleMatch ruleMatch) {
        String sql = "INSERT INTO feed_matches (title, language_code, rule_id, rule_sub_id, rule_description, rule_message, rule_category, error_context, edit_date, diff_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
            prepSt.setString(1, StringUtils.abbreviate((String)ruleMatch.getTitle(), (int)255));
            prepSt.setString(2, ruleMatch.getLanguage().getShortCode());
            prepSt.setString(3, ruleMatch.getRule().getId());
            if (ruleMatch.getRule() instanceof AbstractPatternRule) {
                prepSt.setString(4, ((AbstractPatternRule)ruleMatch.getRule()).getSubId());
            } else {
                prepSt.setString(4, null);
            }
            prepSt.setString(5, StringUtils.abbreviate((String)ruleMatch.getRule().getDescription(), (int)255));
            prepSt.setString(6, StringUtils.abbreviate((String)ruleMatch.getMessage(), (int)255));
            if (ruleMatch.getRule().getCategory() != null) {
                prepSt.setString(7, StringUtils.abbreviate((String)ruleMatch.getRule().getCategory().getName(), (int)255));
            } else {
                prepSt.setString(7, "<no category>");
            }
            prepSt.setString(8, StringUtils.abbreviate((String)ruleMatch.getErrorContext(), (int)500));
            prepSt.setTimestamp(9, new Timestamp(ruleMatch.getEditDate().getTime()));
            prepSt.setLong(10, ruleMatch.getDiffId());
            prepSt.execute();
        }
        catch (SQLException e) {
            if (e.toString().contains("Incorrect string value")) {
                System.err.println("Could not add rule match " + (Object)((Object)ruleMatch) + " to database - stacktrace follows:");
                e.printStackTrace();
            }
            throw new RuntimeException("Could not add rule match " + (Object)((Object)ruleMatch) + " to database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int markedFixed(WikipediaRuleMatch ruleMatch) {
        String sql = "UPDATE feed_matches SET fix_date = ?, fix_diff_id = ? WHERE language_code = ? AND title = ? AND rule_id = ? AND error_context = ?";
        try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
            prepSt.setTimestamp(1, new Timestamp(ruleMatch.getEditDate().getTime()));
            prepSt.setLong(2, ruleMatch.getDiffId());
            prepSt.setString(3, ruleMatch.getLanguage().getShortCode());
            prepSt.setString(4, ruleMatch.getTitle());
            prepSt.setString(5, ruleMatch.getRule().getId());
            prepSt.setString(6, ruleMatch.getErrorContext());
            int n = prepSt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not mark rule match " + (Object)((Object)ruleMatch) + " as fixed in database", e);
        }
    }

    void createTables() throws SQLException {
        try (PreparedStatement prepSt = this.conn.prepareStatement("CREATE TABLE pings (  language_code VARCHAR(5) NOT NULL,  check_date TIMESTAMP NOT NULL)");){
            prepSt.executeUpdate();
        }
        prepSt = this.conn.prepareStatement("CREATE TABLE feed_checks (  language_code VARCHAR(5) NOT NULL,  check_date TIMESTAMP NOT NULL)");
        var2_2 = null;
        try {
            prepSt.executeUpdate();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (prepSt != null) {
                if (var2_2 != null) {
                    try {
                        prepSt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    prepSt.close();
                }
            }
        }
        prepSt = this.conn.prepareStatement("CREATE TABLE feed_matches (  id INT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),  language_code VARCHAR(5) NOT NULL,  title VARCHAR(255) NOT NULL,  rule_id VARCHAR(255) NOT NULL,  rule_sub_id VARCHAR(255),  rule_description VARCHAR(255) NOT NULL,  rule_message VARCHAR(255) NOT NULL,  rule_category VARCHAR(255) NOT NULL,  error_context VARCHAR(500) NOT NULL,  edit_date TIMESTAMP NOT NULL,  diff_id INT NOT NULL,  fix_date TIMESTAMP,  fix_diff_id INT)");
        var2_2 = null;
        try {
            prepSt.executeUpdate();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (prepSt != null) {
                if (var2_2 != null) {
                    try {
                        prepSt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    prepSt.close();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Date getLatestDate(Language language) {
        try {
            String sql = "SELECT check_date FROM feed_checks WHERE language_code = ?";
            try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
                prepSt.setString(1, language.getShortCode());
                ResultSet resultSet = prepSt.executeQuery();
                if (!resultSet.next()) return new Date(0L);
                if (resultSet.getTimestamp("check_date") == null) return new Date(0L);
                Date date = new Date(resultSet.getTimestamp("check_date").getTime());
                return date;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get check_date from database for " + language, e);
        }
    }

    void dropTables() throws SQLException {
        this.dropTable("feed_matches");
        this.dropTable("feed_checks");
        this.dropTable("pings");
    }

    private void dropTable(String tableName) {
        try (PreparedStatement prepSt = this.conn.prepareStatement("DROP TABLE " + tableName);){
            prepSt.execute();
        }
        catch (SQLException e) {
            System.err.println("Note: could not drop table 'feed_matches' - this is okay on the first run: " + e);
        }
    }

    /*
     * Exception decompiling
     */
    List<StoredWikipediaRuleMatch> list() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Map<String, Date> getCheckDates() throws SQLException {
        HashMap<String, Date> result = new HashMap<String, Date>();
        try (PreparedStatement prepSt = this.conn.prepareStatement("SELECT * FROM feed_checks");
             ResultSet resultSet = prepSt.executeQuery();){
            while (resultSet.next()) {
                String langCode = resultSet.getString("language_code");
                Date checkDate = new Date(resultSet.getTimestamp("check_date").getTime());
                result.put(langCode, checkDate);
            }
        }
        return result;
    }
}

