/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.DocumentLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

class DatabaseHandler
extends ResultHandler {
    private static final int MAX_CONTEXT_LENGTH = 500;
    private static final int SMALL_CONTEXT_LENGTH = 40;
    private final Connection conn;
    private final ContextTools contextTools;
    private final ContextTools smallContextTools;
    private final PreparedStatement insertSt;
    private final int batchSize;
    private int batchCount = 0;

    DatabaseHandler(File propertiesFile, int maxSentences, int maxErrors) {
        super(maxSentences, maxErrors);
        String insertSql = "INSERT INTO corpus_match (version, language_code, ruleid, rule_category, rule_subid, rule_description, message, error_context, small_error_context, corpus_date, check_date, sourceuri, source_type, is_visible) VALUES (0, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)";
        Properties dbProperties = new Properties();
        try (FileInputStream inStream = new FileInputStream(propertiesFile);){
            dbProperties.load(inStream);
            String dbUrl = this.getProperty(dbProperties, "dbUrl");
            String dbUser = this.getProperty(dbProperties, "dbUser");
            String dbPassword = this.getProperty(dbProperties, "dbPassword");
            this.batchSize = Integer.decode(dbProperties.getProperty("batchSize", "1"));
            this.conn = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
            this.insertSt = this.conn.prepareStatement(insertSql);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        this.contextTools = new ContextTools();
        this.contextTools.setContextSize(500);
        this.contextTools.setErrorMarkerStart("<err>");
        this.contextTools.setErrorMarkerEnd("</err>");
        this.contextTools.setEscapeHtml(false);
        this.smallContextTools = new ContextTools();
        this.smallContextTools.setContextSize(40);
        this.smallContextTools.setErrorMarkerStart("<err>");
        this.smallContextTools.setErrorMarkerEnd("</err>");
        this.smallContextTools.setEscapeHtml(false);
    }

    private String getProperty(Properties prop, String key) {
        String value = prop.getProperty(key);
        if (value == null) {
            throw new RuntimeException("Required key '" + key + "' not found in properties");
        }
        return value;
    }

    @Override
    protected void handleResult(Sentence sentence, List<RuleMatch> ruleMatches, Language language) {
        try {
            Date nowDate = new Date(new java.util.Date().getTime());
            for (RuleMatch match : ruleMatches) {
                String smallContext = this.smallContextTools.getContext(match.getFromPos(), match.getToPos(), sentence.getText());
                this.insertSt.setString(1, language.getShortCode());
                Rule rule = match.getRule();
                this.insertSt.setString(2, rule.getId());
                this.insertSt.setString(3, rule.getCategory().getName());
                if (rule instanceof AbstractPatternRule) {
                    AbstractPatternRule patternRule = (AbstractPatternRule)rule;
                    this.insertSt.setString(4, patternRule.getSubId());
                } else {
                    this.insertSt.setNull(4, 12);
                }
                this.insertSt.setString(5, rule.getDescription());
                this.insertSt.setString(6, StringUtils.abbreviate((String)match.getMessage(), (int)255));
                String context = this.contextTools.getContext(match.getFromPos(), match.getToPos(), sentence.getText());
                if (context.length() > 500) continue;
                this.insertSt.setString(7, context);
                this.insertSt.setString(8, StringUtils.abbreviate((String)smallContext, (int)255));
                this.insertSt.setDate(9, nowDate);
                this.insertSt.setDate(10, nowDate);
                this.insertSt.setString(11, sentence.getUrl());
                this.insertSt.setString(12, sentence.getSource());
                this.insertSt.addBatch();
                if (++this.batchCount >= this.batchSize) {
                    this.executeBatch();
                    this.batchCount = 0;
                }
                this.checkMaxErrors(++this.errorCount);
                if (this.errorCount % 100 != 0) continue;
                System.out.println("Storing error #" + this.errorCount + " for text:");
                System.out.println("  " + sentence.getText());
            }
            this.checkMaxSentences(++this.sentenceCount);
        }
        catch (DocumentLimitReachedException | ErrorLimitReachedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error storing matches for '" + sentence.getTitle() + "'", e);
        }
    }

    private void executeBatch() throws SQLException {
        boolean autoCommit = this.conn.getAutoCommit();
        this.conn.setAutoCommit(false);
        try {
            this.insertSt.executeBatch();
            if (autoCommit) {
                this.conn.commit();
            }
        }
        finally {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.insertSt != null) {
            if (this.batchCount > 0) {
                this.executeBatch();
            }
            this.insertSt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

