/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;

public class SentenceSourceChecker {
    private SentenceSourceChecker() {
    }

    public static void main(String[] args) throws IOException {
        SentenceSourceChecker prg = new SentenceSourceChecker();
        CommandLine commandLine = SentenceSourceChecker.ensureCorrectUsageOrExit(args);
        File propFile = null;
        if (commandLine.hasOption('d') && (!(propFile = new File(commandLine.getOptionValue('d'))).exists() || propFile.isDirectory())) {
            throw new IOException("File not found or isn't a file: " + propFile.getAbsolutePath());
        }
        String languageCode = commandLine.getOptionValue('l');
        HashSet<String> disabledRuleIds = new HashSet<String>();
        if (commandLine.hasOption("rule-properties")) {
            File disabledRulesPropFile = new File(commandLine.getOptionValue("rule-properties"));
            if (!disabledRulesPropFile.exists() || disabledRulesPropFile.isDirectory()) {
                throw new IOException("File not found or isn't a file: " + disabledRulesPropFile.getAbsolutePath());
            }
            Properties disabledRules = new Properties();
            try (FileInputStream stream = new FileInputStream(disabledRulesPropFile);){
                disabledRules.load(stream);
                SentenceSourceChecker.addDisabledRules("all", disabledRuleIds, disabledRules);
                SentenceSourceChecker.addDisabledRules(languageCode, disabledRuleIds, disabledRules);
            }
        }
        int maxArticles = Integer.parseInt(commandLine.getOptionValue("max-sentences", "0"));
        int maxErrors = Integer.parseInt(commandLine.getOptionValue("max-errors", "0"));
        String[] ruleIds = commandLine.hasOption('r') ? commandLine.getOptionValue('r').split(",") : null;
        String[] categoryIds = commandLine.hasOption("also-enable-categories") ? commandLine.getOptionValue("also-enable-categories").split(",") : null;
        String[] fileNames = commandLine.getOptionValues('f');
        File languageModelDir = commandLine.hasOption("languagemodel") ? new File(commandLine.getOptionValue("languagemodel")) : null;
        File word2vecModelDir = commandLine.hasOption("word2vecmodel") ? new File(commandLine.getOptionValue("word2vecmodel")) : null;
        File neuralNetworkModelDir = commandLine.hasOption("neuralnetworkmodel") ? new File(commandLine.getOptionValue("neuralnetworkmodel")) : null;
        Pattern filter = commandLine.hasOption("filter") ? Pattern.compile(commandLine.getOptionValue("filter")) : null;
        prg.run(propFile, disabledRuleIds, languageCode, Arrays.asList(fileNames), ruleIds, categoryIds, maxArticles, maxErrors, languageModelDir, word2vecModelDir, neuralNetworkModelDir, filter);
    }

    private static void addDisabledRules(String languageCode, Set<String> disabledRuleIds, Properties disabledRules) {
        String disabledRulesString = disabledRules.getProperty(languageCode);
        if (disabledRulesString != null) {
            String[] ids = disabledRulesString.split(",");
            disabledRuleIds.addAll(Arrays.asList(ids));
        }
    }

    private static CommandLine ensureCorrectUsageOrExit(String[] args) {
        Options options = new Options();
        options.addOption(Option.builder((String)"l").longOpt("language").argName("code").hasArg().desc("language code like 'en' or 'de'").required().build());
        options.addOption(Option.builder((String)"d").longOpt("db-properties").argName("file").hasArg().desc("A file to set database access properties. If not set, the output will be written to STDOUT. The file needs to set the properties dbUrl ('jdbc:...'), dbUser, and dbPassword. It can optionally define the batchSize for insert statements, which defaults to 1.").build());
        options.addOption(Option.builder().longOpt("rule-properties").argName("file").hasArg().desc("A file to set rules which should be disabled per language (e.g. en=RULE1,RULE2 or all=RULE3,RULE4)").build());
        options.addOption(Option.builder((String)"r").longOpt("rule-ids").argName("id").hasArg().desc("comma-separated list of rule-ids to activate").build());
        options.addOption(Option.builder().longOpt("also-enable-categories").argName("categories").hasArg().desc("comma-separated list of categories to activate, additionally to rules activated anyway").build());
        options.addOption(Option.builder((String)"f").longOpt("file").argName("file").hasArg().desc("an unpacked Wikipedia XML dump; (must be named *.xml, dumps are available from http://dumps.wikimedia.org/backup-index.html) or a Tatoeba CSV file filtered to contain only one language (must be named tatoeba-*). You can specify this option more than once.").required().build());
        options.addOption(Option.builder().longOpt("max-sentences").argName("number").hasArg().desc("maximum number of sentences to check").build());
        options.addOption(Option.builder().longOpt("max-errors").argName("number").hasArg().desc("maximum number of errors, stop when finding more").build());
        options.addOption(Option.builder().longOpt("languagemodel").argName("indexDir").hasArg().desc("directory with a '3grams' sub directory that contains an ngram index").build());
        options.addOption(Option.builder().longOpt("neuralnetworkmodel").argName("baseDir").hasArg().desc("base directory for saved neural network models").build());
        options.addOption(Option.builder().longOpt("filter").argName("regex").hasArg().desc("Consider only sentences that contain this regular expression (for speed up)").build());
        try {
            DefaultParser parser = new DefaultParser();
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(80);
            formatter.setSyntaxPrefix("Usage: ");
            formatter.printHelp(SentenceSourceChecker.class.getSimpleName() + " [OPTION]... --file <file> --language <code>", options);
            System.exit(1);
            throw new IllegalStateException();
        }
    }

    /*
     * Exception decompiling
     */
    private void run(File propFile, Set<String> disabledRules, String langCode, List<String> fileNames, String[] ruleIds, String[] additionalCategoryIds, int maxSentences, int maxErrors, File languageModelDir, File word2vecModelDir, File neuralNetworkModelDir, Pattern filter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void enableOnlySpecifiedRules(String[] ruleIds, JLanguageTool languageTool) {
        for (Rule rule : languageTool.getAllRules()) {
            languageTool.disableRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            languageTool.enableRule(ruleId);
        }
        this.warnOnNonExistingRuleIds(ruleIds, languageTool);
        System.out.println("Only these rules are enabled: " + Arrays.toString(ruleIds));
    }

    private void warnOnNonExistingRuleIds(String[] ruleIds, JLanguageTool languageTool) {
        for (String ruleId : ruleIds) {
            boolean found = false;
            for (Rule rule : languageTool.getAllRules()) {
                if (!rule.getId().equals(ruleId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("WARNING: Could not find rule '" + ruleId + "'");
        }
    }

    private void applyRuleDeactivation(JLanguageTool languageTool, Set<String> disabledRules) {
        for (String disabledRuleId : disabledRules) {
            languageTool.disableRule(disabledRuleId);
        }
        System.out.println("These rules are disabled: " + languageTool.getDisabledRules());
    }

    private void activateAdditionalCategories(String[] additionalCategoryIds, JLanguageTool languageTool) {
        if (additionalCategoryIds != null) {
            for (String categoryId : additionalCategoryIds) {
                for (Rule rule : languageTool.getAllRules()) {
                    CategoryId id = rule.getCategory().getId();
                    if (id == null || !id.toString().equals(categoryId)) continue;
                    System.out.println("Activating " + rule.getId() + " in category " + categoryId);
                    languageTool.enableRule(rule.getId());
                }
            }
        }
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
        System.out.println("All spelling rules are disabled");
    }
}

