/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.dev.dumpcheck.SentenceSource;

class TatoebaSentenceSource
extends SentenceSource {
    private final List<String> sentences;
    private final Scanner scanner;
    private int articleCount = 0;

    TatoebaSentenceSource(InputStream textInput, Language language) {
        this(textInput, language, null);
    }

    TatoebaSentenceSource(InputStream textInput, Language language, Pattern filter) {
        super(language, filter);
        this.scanner = new Scanner(textInput);
        this.sentences = new ArrayList<String>();
    }

    @Override
    public boolean hasNext() {
        this.fillSentences();
        return this.sentences.size() > 0;
    }

    @Override
    public Sentence next() {
        this.fillSentences();
        if (this.sentences.isEmpty()) {
            throw new NoSuchElementException();
        }
        return new Sentence(this.sentences.remove(0), this.getSource(), "<Tatoeba>", "http://tatoeba.org", ++this.articleCount);
    }

    @Override
    public String getSource() {
        return "tatoeba";
    }

    private void fillSentences() {
        while (this.sentences.isEmpty() && this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            if (line.isEmpty()) continue;
            String[] parts = line.split("\t");
            if (parts.length != 3) {
                throw new RuntimeException("Unexpected line format: expected three tab-separated columns: '" + line + "'");
            }
            String sentence = parts[2];
            if (!this.acceptSentence(sentence)) continue;
            this.sentences.add(sentence);
        }
    }
}

