/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AtomFeedItem {
    private static final Pattern TABLE_DATA_CONTENT = Pattern.compile("<td.*?>(.*)</td>");
    private static final Pattern DIFF_ID_PATTERN = Pattern.compile("diff=(\\d+)");
    private final String id;
    private final String title;
    private final String summary;
    private final Date date;

    AtomFeedItem(String id, String title, String summary, Date date) {
        this.id = Objects.requireNonNull(id);
        this.title = Objects.requireNonNull(title);
        this.summary = Objects.requireNonNull(summary);
        this.date = Objects.requireNonNull(date);
    }

    String getId() {
        return this.id;
    }

    String getTitle() {
        return this.title;
    }

    String getSummary() {
        return this.summary;
    }

    Date getDate() {
        return this.date;
    }

    List<String> getOldContent() {
        return this.getMarkedContent("\u2212");
    }

    List<String> getNewContent() {
        return this.getMarkedContent("+");
    }

    private List<String> getMarkedContent(String plusMinusMarker) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = this.summary.split("\n");
        boolean expectingChange = false;
        for (String line : lines) {
            String cleanContent;
            if (line.trim().startsWith("<td class=\"diff-marker\">" + plusMinusMarker + "</td>")) {
                expectingChange = true;
                continue;
            }
            if (!expectingChange) continue;
            Matcher matcher = TABLE_DATA_CONTENT.matcher(line);
            if (matcher.find()) {
                cleanContent = matcher.group(1);
                if (cleanContent.matches(".*<div.*?>[!\\|].*") && cleanContent.matches(".*\\w!!\\w.*")) {
                    cleanContent = cleanContent.replaceAll("<div.*?>[!\\|].*?</div>", "");
                }
            } else {
                throw new RuntimeException("Expected change ('" + plusMinusMarker + "') not found in line: " + line);
            }
            cleanContent = cleanContent.replaceAll("<span.*?>", "").replace("</span>", "").replaceAll("<div.*?>[!\\|]", "").replace("<div>", "").replaceAll("<div.*?>", "").replace("</div>", "").replaceAll("<ins.*?>", "").replace("</ins>", "").replaceAll("<del.*?>", "").replace("</del>", "").replaceAll("<!--.*?-->", "");
            result.add(cleanContent);
            expectingChange = false;
        }
        return result;
    }

    public long getDiffId() {
        Matcher matcher = DIFF_ID_PATTERN.matcher(this.id);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        return 0L;
    }

    public String toString() {
        return "AtomFeedItem{id='" + this.id + '\'' + ", title='" + this.title + "'}";
    }
}

