/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.util.List;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

class StdoutHandler
extends ResultHandler {
    private final ContextTools contextTools = new ContextTools();

    StdoutHandler(int maxSentences, int maxErrors) {
        super(maxSentences, maxErrors);
        this.contextTools.setContextSize(50);
    }

    @Override
    protected void handleResult(Sentence sentence, List<RuleMatch> ruleMatches, Language language) {
        if (ruleMatches.size() > 0) {
            int i = 1;
            System.out.println("\nTitle: " + sentence.getTitle());
            for (RuleMatch match : ruleMatches) {
                AbstractPatternRule pRule;
                String output = i + ".) Line " + (match.getLine() + 1) + ", column " + match.getColumn() + ", Rule ID: " + match.getRule().getId();
                if (match.getRule() instanceof AbstractPatternRule) {
                    AbstractPatternRule pRule2 = (AbstractPatternRule)match.getRule();
                    output = output + "[" + pRule2.getSubId() + "]";
                }
                if (match.getRule().isDefaultTempOff()) {
                    output = output + " [temp_off]";
                }
                System.out.println(output);
                String msg = match.getMessage();
                msg = msg.replaceAll("<suggestion>", "'");
                msg = msg.replaceAll("</suggestion>", "'");
                System.out.println("Message: " + msg);
                List replacements = match.getSuggestedReplacements();
                if (!replacements.isEmpty()) {
                    System.out.println("Suggestion: " + String.join((CharSequence)"; ", replacements));
                }
                if (match.getRule() instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)match.getRule()).getSourceFile() != null) {
                    System.out.println("Rule source: " + pRule.getSourceFile());
                }
                System.out.println(this.contextTools.getPlainTextContext(match.getFromPos(), match.getToPos(), sentence.getText()));
                ++i;
                this.checkMaxErrors(++this.errorCount);
            }
        }
        this.checkMaxSentences(++this.sentenceCount);
    }

    @Override
    public void close() throws Exception {
    }
}

