/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.dev.index.UnsupportedPatternRuleException;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.synthesis.Synthesizer;

public class PatternRuleQueryBuilder {
    public static final String FIELD_NAME = "field";
    public static final String SOURCE_FIELD_NAME = "source";
    public static final String FIELD_NAME_LOWERCASE = "fieldLowercase";
    private final Language language;
    private final IndexSearcher indexSearcher;
    private final String searchFieldName;

    public PatternRuleQueryBuilder(Language language, IndexSearcher indexSearcher) {
        this(language, indexSearcher, FIELD_NAME_LOWERCASE);
    }

    public PatternRuleQueryBuilder(Language language, IndexSearcher indexSearcher, String searchFieldName) {
        this.language = language;
        this.indexSearcher = indexSearcher;
        this.searchFieldName = searchFieldName;
    }

    public Query buildRelaxedQuery(AbstractPatternRule rule) throws UnsupportedPatternRuleException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (PatternToken patternToken : rule.getPatternTokens()) {
            try {
                BooleanClause clause = this.makeQuery(patternToken);
                builder.add(clause);
            }
            catch (UnsupportedPatternRuleException clause) {
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create query for rule " + rule.getId(), e);
            }
        }
        BooleanQuery query = builder.build();
        if (query.clauses().isEmpty()) {
            throw new UnsupportedPatternRuleException("No items found in rule that can be used to build a search query: " + rule);
        }
        return query;
    }

    private BooleanClause makeQuery(PatternToken patternToken) throws UnsupportedPatternRuleException {
        this.checkUnsupportedElement(patternToken);
        String termStr = patternToken.getString();
        String pos = patternToken.getPOStag();
        BooleanClause termQuery = this.getTermQueryOrNull(patternToken, termStr);
        BooleanClause posQuery = this.getPosQueryOrNull(patternToken, pos);
        if (termQuery != null && posQuery != null) {
            if (this.mustOccur(termQuery) && this.mustOccur(posQuery)) {
                SpanQuery spanQueryForTerm = this.asSpanQuery(termQuery);
                SpanQuery spanQueryForPos = this.asSpanQuery(posQuery);
                SpanQuery[] spanClauses = new SpanQuery[]{spanQueryForTerm, spanQueryForPos};
                return new BooleanClause((Query)new SpanNearQuery(spanClauses, 0, false), BooleanClause.Occur.MUST);
            }
            throw new UnsupportedPatternRuleException("Term/POS combination not supported yet: " + patternToken);
        }
        if (termQuery != null) {
            return termQuery;
        }
        if (posQuery != null) {
            return posQuery;
        }
        throw new UnsupportedPatternRuleException("Neither POS tag nor term set for element: " + patternToken);
    }

    private SpanQuery asSpanQuery(BooleanClause query) {
        if (query.getQuery() instanceof MultiTermQuery) {
            return new SpanMultiTermQueryWrapper((MultiTermQuery)query.getQuery());
        }
        HashSet terms = new HashSet();
        try {
            this.indexSearcher.createWeight(query.getQuery(), false).extractTerms(terms);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (terms.size() != 1) {
            throw new RuntimeException("Expected term set of size 1: " + terms);
        }
        return new SpanTermQuery((Term)terms.iterator().next());
    }

    private boolean mustOccur(BooleanClause query) {
        return query != null && query.getOccur() == BooleanClause.Occur.MUST;
    }

    @Nullable
    private BooleanClause getTermQueryOrNull(PatternToken patternToken, String termStr) throws UnsupportedPatternRuleException {
        if (termStr == null || termStr.isEmpty()) {
            return null;
        }
        Term termQueryTerm = this.getTermQueryTerm(termStr);
        if (patternToken.getNegation() || patternToken.getMinOccurrence() == 0) {
            return null;
        }
        if (patternToken.isInflected() && patternToken.isRegularExpression()) {
            Term lemmaQueryTerm = this.getQueryTerm("_LEMMA_(", this.simplifyRegex(termStr), ")");
            Query regexpQuery = this.getRegexQuery(lemmaQueryTerm, termStr, patternToken);
            return new BooleanClause(regexpQuery, BooleanClause.Occur.MUST);
        }
        if (patternToken.isInflected() && !patternToken.isRegularExpression()) {
            Synthesizer synthesizer = this.language.getSynthesizer();
            if (synthesizer != null) {
                try {
                    Object[] synthesized = synthesizer.synthesize(new AnalyzedToken(termStr, null, termStr), ".*", true);
                    Object query = synthesized.length == 0 ? new TermQuery(termQueryTerm) : new RegexpQuery(this.getTermQueryTerm(StringUtils.join((Object[])synthesized, (String)"|")));
                    return new BooleanClause((Query)query, BooleanClause.Occur.MUST);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not build Lucene query for '" + patternToken + "' and '" + termStr + "'", e);
                }
            }
            return null;
        }
        Object termQuery = patternToken.isRegularExpression() ? this.getRegexQuery(termQueryTerm, termStr, patternToken) : new TermQuery(termQueryTerm);
        return new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST);
    }

    private String simplifyRegex(String regex) {
        return regex.replace("(?:", "(").replace("\\d", "[0-9]").replace("\\w", "[a-zA-Z_0-9]");
    }

    private boolean needsSimplification(String regex) {
        return regex.contains("(?:") || regex.contains("\\d") || regex.contains("\\w");
    }

    @Nullable
    private BooleanClause getPosQueryOrNull(PatternToken patternToken, String pos) throws UnsupportedPatternRuleException {
        TermQuery posQuery;
        if (pos == null || pos.isEmpty()) {
            return null;
        }
        if (patternToken.getPOSNegation() || patternToken.getMinOccurrence() == 0) {
            return null;
        }
        if (patternToken.isPOStagRegularExpression()) {
            Term posQueryTerm = this.getQueryTerm("_POS_(", pos, ")");
            posQuery = this.getRegexQuery(posQueryTerm, pos, patternToken);
        } else {
            Term posQueryTerm = this.getQueryTerm("_POS_", pos, "");
            posQuery = new TermQuery(posQueryTerm);
        }
        return new BooleanClause((Query)posQuery, BooleanClause.Occur.MUST);
    }

    private Term getTermQueryTerm(String str) {
        return new Term(this.searchFieldName, str.toLowerCase());
    }

    private Term getQueryTerm(String prefix, String str, String suffix) {
        return new Term(this.searchFieldName, prefix.toLowerCase() + str.toLowerCase() + suffix.toLowerCase());
    }

    private Query getRegexQuery(Term term, String str, PatternToken patternToken) throws UnsupportedPatternRuleException {
        try {
            if (this.needsSimplification(str)) {
                Term newTerm = new Term(term.field(), this.simplifyRegex(term.text()));
                return new RegexpQuery(newTerm);
            }
            if (str.contains("?iu") || str.contains("?-i")) {
                throw new UnsupportedPatternRuleException("Regex constructs like '?iu' and '?-i' are not supported: " + patternToken);
            }
            return new RegexpQuery(term);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedPatternRuleException("Advanced regex like '\\p{Punct}' are not supported: " + patternToken);
        }
    }

    private void checkUnsupportedElement(PatternToken patternPatternToken) throws UnsupportedPatternRuleException {
        if (patternPatternToken.hasOrGroup()) {
            throw new UnsupportedPatternRuleException("<or> not yet supported.");
        }
        if (patternPatternToken.isUnified()) {
            throw new UnsupportedPatternRuleException("Elements with unified tokens are not supported.");
        }
        if (patternPatternToken.getString() != null && patternPatternToken.getString().matches("\\\\\\d+")) {
            throw new UnsupportedPatternRuleException("Elements with only match references (e.g. \\1) are not supported.");
        }
    }
}

