/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import org.apache.commons.lang3.StringUtils;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.TextConverter;
import org.languagetool.dev.wikipedia.TextMapFilter;
import org.sweble.wikitext.engine.CompiledPage;
import org.sweble.wikitext.engine.Compiler;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.utils.SimpleWikiConfiguration;

public class SwebleWikipediaTextFilter
implements TextMapFilter {
    private static final int WRAP_COL = Integer.MAX_VALUE;
    private final SimpleWikiConfiguration config;
    private final Compiler compiler;
    private final PageId pageId;
    private boolean enableMapping = true;

    public SwebleWikipediaTextFilter() {
        try {
            this.config = new SimpleWikiConfiguration("classpath:/org/languagetool/resource/dev/SimpleWikiConfiguration.xml");
            this.compiler = new Compiler((WikiConfigurationInterface)this.config);
            PageTitle pageTitle = PageTitle.make((WikiConfigurationInterface)this.config, (String)"fileTitle");
            this.pageId = new PageId(pageTitle, -1L);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set up text filter", e);
        }
    }

    @Override
    public PlainTextMapping filter(String wikiText) {
        try {
            CompiledPage compiledPage = this.compiler.postprocess(this.pageId, wikiText, null);
            TextConverter textConverter = new TextConverter(this.config, Integer.MAX_VALUE);
            textConverter.enableMapping(this.enableMapping);
            String plainText = (String)textConverter.go(compiledPage.getPage());
            if (this.enableMapping) {
                return new PlainTextMapping(plainText, textConverter.getMapping());
            }
            return new PlainTextMapping(plainText, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract plain text from MediaWiki syntax: '" + StringUtils.abbreviate((String)wikiText, (int)500) + "'", e);
        }
    }

    public void enableMapping(boolean enable) {
        this.enableMapping = enable;
    }
}

