/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.dumpcheck.WikipediaSentenceSource;

class WikipediaSentenceExtractor {
    WikipediaSentenceExtractor() {
    }

    private void extract(Language language, String xmlDumpPath, String outputFile) throws IOException, CompressorException {
        try (FileInputStream fis = new FileInputStream(xmlDumpPath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             FileWriter fw = new FileWriter(outputFile);){
            Object input;
            if (xmlDumpPath.endsWith(".bz2")) {
                input = new CompressorStreamFactory().createCompressorInputStream((InputStream)bis);
            } else if (xmlDumpPath.endsWith(".xml")) {
                input = bis;
            } else {
                throw new IllegalArgumentException("Unknown file name, expected '.xml' or '.bz2': " + xmlDumpPath);
            }
            int sentenceCount = 0;
            WikipediaSentenceSource source = new WikipediaSentenceSource((InputStream)input, language);
            while (source.hasNext()) {
                String sentence = source.next().getText();
                if (this.skipSentence(sentence)) continue;
                fw.write(sentence);
                fw.write(10);
                if (++sentenceCount % 1000 != 0) continue;
                System.err.println("Exporting sentence #" + sentenceCount + "...");
            }
        }
    }

    private boolean skipSentence(String sentence) {
        return sentence.trim().length() == 0 || Character.isLowerCase(sentence.trim().charAt(0));
    }

    public static void main(String[] args) throws IOException, CompressorException {
        if (args.length != 3) {
            System.out.println("Usage: " + WikipediaSentenceExtractor.class.getSimpleName() + " <langCode> <wikipediaXmlDump> <output>");
            System.exit(1);
        }
        WikipediaSentenceExtractor extractor = new WikipediaSentenceExtractor();
        extractor.extract(Languages.getLanguageForShortCode((String)args[0]), args[1], args[2]);
    }
}

