/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import xtc.tree.Location;

public class LocationHelper {
    private LocationHelper() {
    }

    public static int absolutePositionFor(Location location, String text) {
        int line = 1;
        int col = 1;
        int pos = 0;
        int ignoreLevel = 0;
        boolean inReference = false;
        StringBuilder relevantLine = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int prevCh;
            char ch = text.charAt(i);
            if (line == location.line) {
                relevantLine.append(ch);
            }
            if (line == location.line && col == location.column) {
                return pos;
            }
            int n = prevCh = i > 0 ? (int)text.charAt(i - 1) : 45;
            if (LocationHelper.isReferenceStart(text, i)) {
                ++ignoreLevel;
                inReference = true;
            } else if (inReference && (LocationHelper.isFullReferenceEndTag(text, i) || LocationHelper.isShortReferenceEndTag(text, i))) {
                --ignoreLevel;
                inReference = false;
                if (LocationHelper.isShortReferenceEndTag(text, i)) {
                    ++col;
                }
            } else if (LocationHelper.isHtmlCommentStart(text, i)) {
                ++ignoreLevel;
            } else if (LocationHelper.isHtmlCommentEnd(text, i)) {
                --ignoreLevel;
            } else if (ch == '}' && prevCh == 125) {
                if (ignoreLevel > 0) {
                    --ignoreLevel;
                }
            } else if (ch == '{' && prevCh == 123) {
                ++ignoreLevel;
            } else if (ch == '\n' && ignoreLevel == 0) {
                ++line;
                col = 1;
            } else if (ignoreLevel == 0) {
                ++col;
            }
            ++pos;
        }
        if (line == location.line && col == location.column) {
            return pos;
        }
        throw new RuntimeException("Could not find location " + location + " in text. Max line/col was: " + line + "/" + col + ", Content of relevant line (" + location.line + "): '" + relevantLine + "' (" + relevantLine.length() + " chars)");
    }

    private static boolean isReferenceStart(String text, int i) {
        return text.startsWith("<ref", i);
    }

    private static boolean isFullReferenceEndTag(String text, int i) {
        return text.startsWith("</ref>", i);
    }

    private static boolean isShortReferenceEndTag(String text, int i) {
        return text.startsWith("/>", i);
    }

    private static boolean isHtmlCommentStart(String text, int i) {
        return text.startsWith("<!--", i);
    }

    private static boolean isHtmlCommentEnd(String text, int i) {
        return text.startsWith("-->", i);
    }
}

