/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.util.Map;
import xtc.tree.Location;

public class PlainTextMapping {
    private final String plainText;
    private final Map<Integer, Location> mapping;

    public PlainTextMapping(String plainText, Map<Integer, Location> mapping) {
        this.plainText = plainText;
        this.mapping = mapping;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public Map<Integer, Location> getMapping() {
        return this.mapping;
    }

    public Location getOriginalTextPositionFor(int plainTextPosition) {
        if (plainTextPosition < 1) {
            throw new RuntimeException("plainTextPosition must be > 0 - its value starts at 1");
        }
        Location origPosition = this.mapping.get(plainTextPosition);
        if (origPosition != null) {
            return origPosition;
        }
        int minDiff = Integer.MAX_VALUE;
        Location bestMatch = null;
        for (Map.Entry<Integer, Location> entry : this.mapping.entrySet()) {
            int diff;
            int maybeClosePosition = entry.getKey();
            if (plainTextPosition <= maybeClosePosition || (diff = plainTextPosition - maybeClosePosition) < 0 || diff >= minDiff) continue;
            bestMatch = entry.getValue();
            minDiff = diff;
        }
        if (bestMatch == null) {
            throw new RuntimeException("Could not map " + plainTextPosition + " to original position. Mapping: " + this.mapping);
        }
        return new Location(bestMatch.file, bestMatch.line, bestMatch.column + minDiff);
    }
}

