/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Scanner;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

final class RareWordsFinder {
    private static final String dictInClassPath = "/en/hunspell/en_US.dict";
    private final HunspellDictionary hunspell;

    private RareWordsFinder(String hunspellBase) throws IOException {
        this.hunspell = Hunspell.getDictionary((Path)Paths.get(hunspellBase + ".dic", new String[0]), (Path)Paths.get(hunspellBase + ".aff", new String[0]));
    }

    private void run(File input, int minimum) throws FileNotFoundException, CharacterCodingException {
        MorfologikSpeller speller = new MorfologikSpeller(dictInClassPath, 1);
        int lineCount = 0;
        int wordCount = 0;
        try (Scanner s = new Scanner(input);){
            while (s.hasNextLine()) {
                boolean isMisspelled;
                String line = s.nextLine();
                String[] parts = line.split("\t");
                String word = parts[0];
                long count = Long.parseLong(parts[1]);
                if (!(count > (long)minimum || !word.matches("[a-zA-Z]+") || word.matches("[A-Z]+") || word.matches("[a-zA-Z]+[A-Z]+[a-zA-Z]*") || word.matches("[A-Z].*") || (isMisspelled = speller.isMisspelled(word)))) {
                    List suggestions = this.hunspell.suggest(word);
                    suggestions.remove(word);
                    if (this.suggestionsMightBeUseful(word, suggestions)) {
                        System.out.println(word + "\t" + count + " -> " + String.join((CharSequence)", ", suggestions));
                        ++wordCount;
                    }
                }
                if (++lineCount % 1000000 != 0) continue;
                System.out.println("lineCount: " + lineCount + ", words found: " + wordCount);
            }
            System.out.println("Done. lineCount: " + lineCount + ", words found: " + wordCount);
        }
    }

    private boolean suggestionsMightBeUseful(String word, List<String> suggestions) {
        return suggestions.size() > 0 && !suggestions.get(0).contains(" ") && !suggestions.get(0).equals(word + "s") && !suggestions.get(0).equals(word.replaceFirst("s$", ""));
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Usage: " + RareWordsFinder.class.getSimpleName() + " <wordFile> <hunspellBase> <limit>");
            System.out.println("    <wordFile> is a word file with occurrence counts, separated by tabs");
            System.out.println("    <hunspellBase> is the hunspell file without suffix, e.g. '/path/to/en_US'");
            System.out.println("    <limit> only words with this many or less occurrences are considered");
            System.exit(1);
        }
        RareWordsFinder finder = new RareWordsFinder(args[1]);
        File input = new File(args[0]);
        int minimum = Integer.parseInt(args[2]);
        finder.run(input, minimum);
    }
}

