/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.util.List;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.RuleMatch;

class CSVHandler
extends ResultHandler {
    CSVHandler(int maxSentences, int maxErrors) {
        super(maxSentences, maxErrors);
    }

    @Override
    protected void handleResult(Sentence sentence, List<RuleMatch> ruleMatches, Language language) {
        String sentenceStr = sentence.getText();
        if (ruleMatches.size() > 0) {
            for (RuleMatch match : ruleMatches) {
                sentenceStr = this.noTabs(sentenceStr.substring(0, match.getFromPos())) + "__" + this.noTabs(sentenceStr.substring(match.getFromPos(), match.getToPos())) + "__" + this.noTabs(sentenceStr.substring(match.getToPos()));
                System.out.println("MATCH\t" + match.getRule().getFullId() + "\t" + this.noTabs(sentenceStr));
                this.checkMaxErrors(++this.errorCount);
            }
        } else {
            System.out.println("NOMATCH\t\t" + this.noTabs(sentenceStr));
        }
        this.checkMaxSentences(++this.sentenceCount);
    }

    private String noTabs(String s) {
        return s.replace("\t", "\\t");
    }

    @Override
    public void close() throws Exception {
    }
}

