/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import de.fau.cs.osr.ptk.common.AstVisitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import xtc.tree.Locatable;
import xtc.tree.Location;

public class TextConverter
extends AstVisitor {
    private static final Pattern ws = Pattern.compile("\\s+");
    private Map<Integer, Location> mapping = new HashMap<Integer, Location>();
    private StringBuilder sb;
    private StringBuilder line;
    private boolean pastBod;
    private int needNewlines;
    private boolean needSpace;
    private boolean noWrap;
    private LinkedList<Integer> sections;
    private boolean enableMapping = true;
    private boolean inGallery = false;
    private boolean inSource = false;

    public void enableMapping(boolean enableMapping) {
        this.enableMapping = enableMapping;
    }

    public Map<Integer, Location> getMapping() {
        if (!this.enableMapping) {
            throw new IllegalStateException("enableMapping not activated");
        }
        return this.mapping;
    }

    private void addMapping(Locatable loc) {
        this.addMapping(loc, 0);
    }

    private void addMapping(Locatable loc, int columnCorrection) {
        if (!this.enableMapping) {
            return;
        }
        String contentSoFar = this.sb.toString() + this.line;
        int textPos = contentSoFar.length() + this.needNewlines + 1;
        if (loc.hasLocation()) {
            Location location = loc.getLocation();
            this.mapping.put(textPos, new Location(location.file, location.line, location.column + columnCorrection));
        }
    }

    private void newline(int num) {
        if (this.pastBod && num > this.needNewlines) {
            this.needNewlines = num;
        }
    }

    private void wantSpace() {
        if (this.pastBod) {
            this.needSpace = true;
        }
    }

    private void finishLine() {
        this.sb.append((CharSequence)this.line);
        this.line.setLength(0);
    }

    private void writeNewlines(int num) {
        this.finishLine();
        for (int i = 0; i < num; ++i) {
            this.sb.append('\n');
        }
        this.needNewlines = 0;
        this.needSpace = false;
    }
}

