/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.laoruga.dtogenerator.DtoGeneratorBuilder;

public class DtoGeneratorBuildersTree {
    public static final String ROOT = "%ROOT%";
    private final Node tree;

    public DtoGeneratorBuildersTree(DtoGeneratorBuilder<?> rootBuilder) {
        this.tree = new Node(ROOT, rootBuilder);
    }

    public DtoGeneratorBuilder<?> getBuilder(String[] fields) {
        Node prev = this.tree;
        Node next = null;
        for (String field : fields) {
            if (ROOT.equals(field)) continue;
            Optional<Node> maybeNode = prev.getChildren().stream().filter(node -> field.equals(node.getFieldName())).findFirst();
            if (maybeNode.isPresent()) {
                next = maybeNode.get();
                continue;
            }
            next = new Node(field, new DtoGeneratorBuilder(this.tree.getBuilder(), fields));
            prev.getChildren().add(next);
        }
        return ((Node)Objects.requireNonNull(next, "Unexpected error")).getBuilder();
    }

    public DtoGeneratorBuildersTree(Node tree) {
        this.tree = tree;
    }

    static class Node {
        private final String fieldName;
        private final DtoGeneratorBuilder<?> builder;
        private List<Node> children = new LinkedList<Node>();

        public String getFieldName() {
            return this.fieldName;
        }

        public DtoGeneratorBuilder<?> getBuilder() {
            return this.builder;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public void setChildren(List<Node> children) {
            this.children = children;
        }

        public Node(String fieldName, DtoGeneratorBuilder<?> builder) {
            this.fieldName = fieldName;
            this.builder = builder;
        }
    }
}

