/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorsHolder {
    private final AtomicReference<Object> errors = new AtomicReference();

    public boolean isEmpty() {
        return this.getErrors().isEmpty();
    }

    public void put(Field field, Exception e) {
        this.getErrors().put(field, e);
    }

    public String toString() {
        AtomicInteger counter = new AtomicInteger(0);
        return this.getErrors().entrySet().stream().map(fieldExceptionEntry -> "- [" + counter.incrementAndGet() + "] Field: '" + ((Field)fieldExceptionEntry.getKey()).toString() + "'\n- [" + counter.get() + "] Exception:\n" + ExceptionUtils.getStackTrace((Throwable)fieldExceptionEntry.getValue())).collect(Collectors.joining("\n"));
    }

    public int size() {
        return this.getErrors().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Field, Exception> getErrors() {
        Serializable value = this.errors.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.errors;
            synchronized (atomicReference) {
                value = this.errors.get();
                if (value == null) {
                    LinkedHashMap actualValue = new LinkedHashMap();
                    value = actualValue == null ? this.errors : actualValue;
                    this.errors.set(value);
                }
            }
        }
        return (Map)((Object)(value == this.errors ? null : value));
    }
}

