/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGenerator;
import org.laoruga.dtogenerator.api.remarks.CustomRuleRemarkWrapper;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public class TypeGeneratorRemarksProvider {
    private final Map<String, IRuleRemark> basicRuleRemarksMapByField = new HashMap<String, IRuleRemark>();
    private final AtomicReference<IRuleRemark> basicRuleRemarkForFields;
    private final Map<String, List<CustomRuleRemarkWrapper>> customRuleRemarksMapByField = new HashMap<String, List<CustomRuleRemarkWrapper>>();
    private final Map<Class<? extends ICustomGenerator<?>>, List<CustomRuleRemarkWrapper>> customRuleRemarksMap;

    public TypeGeneratorRemarksProvider() {
        this(new AtomicReference<IRuleRemark>(), new ConcurrentHashMap());
    }

    private TypeGeneratorRemarksProvider(AtomicReference<IRuleRemark> basicRuleRemarkForFields, Map<Class<? extends ICustomGenerator<?>>, List<CustomRuleRemarkWrapper>> customRuleRemarksMap) {
        this.basicRuleRemarkForFields = basicRuleRemarkForFields;
        this.customRuleRemarksMap = customRuleRemarksMap;
    }

    boolean isBasicRuleRemarkExists(String fieldName) {
        return this.basicRuleRemarksMapByField.containsKey(fieldName) || this.basicRuleRemarkForFields.get() != null;
    }

    void setBasicRuleRemarkForField(@NonNull String filedName, @NonNull RuleRemark ruleRemark) {
        if (filedName == null) {
            throw new NullPointerException("filedName is marked non-null but is null");
        }
        if (ruleRemark == null) {
            throw new NullPointerException("ruleRemark is marked non-null but is null");
        }
        if (this.basicRuleRemarksMapByField.containsKey(filedName)) {
            throw new DtoGeneratorException("Try to overwrite remark from: '" + this.getBasicRuleRemark(filedName) + "' to: '" + ruleRemark + "' for field '" + filedName + "'.");
        }
        this.basicRuleRemarksMapByField.put(filedName, ruleRemark);
    }

    public void setBasicRuleRemarkForFields(RuleRemark basicRuleRemark) {
        if (this.basicRuleRemarkForFields.get() != null && this.basicRuleRemarkForFields.get() != basicRuleRemark) {
            throw new DtoGeneratorException("Try to overwrite remark for all fields from: '" + this.basicRuleRemarkForFields.get() + "' to: '" + basicRuleRemark + "'.");
        }
        this.basicRuleRemarkForFields.set(basicRuleRemark);
    }

    IRuleRemark getBasicRuleRemark(String fieldName) throws NullPointerException {
        if (this.basicRuleRemarksMapByField.containsKey(fieldName)) {
            return this.basicRuleRemarksMapByField.get(fieldName);
        }
        return Objects.requireNonNull(this.basicRuleRemarkForFields.get());
    }

    boolean isCustomRuleRemarkExists(ICustomGenerator<?> customGenerator) {
        return this.customRuleRemarksMap.containsKey(customGenerator.getClass());
    }

    boolean isCustomRuleRemarkExists(String fieldName) {
        return this.customRuleRemarksMapByField.containsKey(fieldName);
    }

    List<CustomRuleRemarkWrapper> getCustomRuleRemarks(ICustomGenerator<?> customGenerator) {
        return this.customRuleRemarksMap.get(customGenerator.getClass());
    }

    List<CustomRuleRemarkWrapper> getCustomRuleRemarks(String fieldName) {
        return this.customRuleRemarksMapByField.get(fieldName);
    }

    public Optional<List<CustomRuleRemarkWrapper>> getRemarks(String fieldName, ICustomGenerator<?> remarkableGenerator) {
        List<Object> mappedByGenerator;
        List<Object> mappedByField = this.isCustomRuleRemarkExists(fieldName) ? this.getCustomRuleRemarks(fieldName) : new ArrayList();
        List<Object> list = mappedByGenerator = this.isCustomRuleRemarkExists(remarkableGenerator) ? this.getCustomRuleRemarks(remarkableGenerator) : new ArrayList();
        if (mappedByGenerator.isEmpty() && mappedByField.isEmpty()) {
            return Optional.empty();
        }
        if (!mappedByField.isEmpty() && !mappedByGenerator.isEmpty()) {
            Iterator<Object> iterator = mappedByGenerator.iterator();
            while (iterator.hasNext()) {
                CustomRuleRemarkWrapper remarkMappedByGenerator = (CustomRuleRemarkWrapper)iterator.next();
                Optional<CustomRuleRemarkWrapper> sameRemark = mappedByField.stream().filter(i -> i.getWrappedRuleRemark().equals(remarkMappedByGenerator.getWrappedRuleRemark())).findAny();
                if (!sameRemark.isPresent()) continue;
                iterator.remove();
            }
        }
        mappedByField.addAll(mappedByGenerator);
        return Optional.of(mappedByField);
    }

    public void addCustomRuleRemarkForField(@NonNull String filedName, CustomRuleRemarkWrapper ... ruleRemark) {
        if (filedName == null) {
            throw new NullPointerException("filedName is marked non-null but is null");
        }
        if (ruleRemark == null) {
            throw new NullPointerException("ruleRemark is marked non-null but is null");
        }
        this.customRuleRemarksMapByField.putIfAbsent(filedName, new LinkedList());
        for (CustomRuleRemarkWrapper remark : ruleRemark) {
            this.customRuleRemarksMapByField.get(filedName).add(remark);
        }
    }

    public void addRuleRemarkForAllFields(CustomRuleRemarkWrapper ... ruleRemarks) {
        if (ruleRemarks == null) {
            throw new NullPointerException("ruleRemarks is marked non-null but is null");
        }
        for (CustomRuleRemarkWrapper remark : ruleRemarks) {
            this.customRuleRemarksMap.putIfAbsent(remark.getGeneratorClass(), new LinkedList());
            this.customRuleRemarksMap.get(remark.getGeneratorClass()).add(remark);
        }
    }

    TypeGeneratorRemarksProvider copy() {
        return new TypeGeneratorRemarksProvider(this.basicRuleRemarkForFields, this.customRuleRemarksMap);
    }
}

