/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.api.remarks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGenerator;
import org.laoruga.dtogenerator.api.remarks.ICustomRuleRemark;

public final class CustomRuleRemarkWrapper {
    private final ICustomRuleRemark wrappedRuleRemark;
    private final Class<? extends ICustomGenerator<?>> generatorClass;
    @NonNull
    private final String[] args;

    public String[] getArgs() {
        return Arrays.copyOf(this.args, this.args.length);
    }

    public List<String> getArgsList() {
        if (this.getArgs() == null || this.getArgs().length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.getArgs());
    }

    public CustomRuleRemarkWrapper(ICustomRuleRemark wrappedRuleRemark, Class<? extends ICustomGenerator<?>> generatorClass, @NonNull String[] args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.wrappedRuleRemark = wrappedRuleRemark;
        this.generatorClass = generatorClass;
        this.args = args;
    }

    public ICustomRuleRemark getWrappedRuleRemark() {
        return this.wrappedRuleRemark;
    }

    public Class<? extends ICustomGenerator<?>> getGeneratorClass() {
        return this.generatorClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomRuleRemarkWrapper)) {
            return false;
        }
        CustomRuleRemarkWrapper other = (CustomRuleRemarkWrapper)o;
        ICustomRuleRemark this$wrappedRuleRemark = this.getWrappedRuleRemark();
        ICustomRuleRemark other$wrappedRuleRemark = other.getWrappedRuleRemark();
        if (this$wrappedRuleRemark == null ? other$wrappedRuleRemark != null : !this$wrappedRuleRemark.equals(other$wrappedRuleRemark)) {
            return false;
        }
        Class<ICustomGenerator<?>> this$generatorClass = this.getGeneratorClass();
        Class<? extends ICustomGenerator<?>> other$generatorClass = other.getGeneratorClass();
        if (this$generatorClass == null ? other$generatorClass != null : !this$generatorClass.equals(other$generatorClass)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ICustomRuleRemark $wrappedRuleRemark = this.getWrappedRuleRemark();
        result = result * 59 + ($wrappedRuleRemark == null ? 43 : $wrappedRuleRemark.hashCode());
        Class<ICustomGenerator<?>> $generatorClass = this.getGeneratorClass();
        result = result * 59 + ($generatorClass == null ? 43 : $generatorClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "CustomRuleRemarkWrapper(wrappedRuleRemark=" + this.getWrappedRuleRemark() + ", generatorClass=" + this.getGeneratorClass() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }
}

