/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.CollectionGenerator;
import org.laoruga.dtogenerator.typegenerators.DoubleGenerator;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.typegenerators.IntegerGenerator;
import org.laoruga.dtogenerator.typegenerators.LocalDateTimeGenerator;
import org.laoruga.dtogenerator.typegenerators.LongGenerator;
import org.laoruga.dtogenerator.typegenerators.StringGenerator;

public class TypeGeneratorBuildersConfig {
    Map<Class<? extends IGeneratorBuilder>, Supplier<IConfigDto>> configMap = new HashMap<Class<? extends IGeneratorBuilder>, Supplier<IConfigDto>>();
    Map<Class<? extends IGeneratorBuilder>, Map<Class<?>, Supplier<IConfigDto>>> doubleKeyConfigMap = new HashMap();

    public void setConfig(IConfigDto configDto) {
        this.setConfig(configDto.getBuilderClass(), () -> configDto);
    }

    void setConfig(Class<? extends IGeneratorBuilder> genBuilderClass, Supplier<IConfigDto> configDtoSupplier) {
        if (genBuilderClass.isAssignableFrom(CollectionGenerator.CollectionGeneratorBuilder.class)) {
            throw new DtoGeneratorException("For collection builder configuration use 'setCollectionConfig' method.");
        }
        this.configMap.put(genBuilderClass, configDtoSupplier);
    }

    public void setCollectionConfig(Class<?> superTypeClass, IConfigDto configDto) {
        this.setCollectionConfig(superTypeClass, () -> configDto);
    }

    void setCollectionConfig(Class<?> superTypeClass, Supplier<IConfigDto> configDtoSupplier) {
        Class<? extends IGeneratorBuilder> genBuilderClass = configDtoSupplier.get().getBuilderClass();
        this.doubleKeyConfigMap.putIfAbsent(genBuilderClass, new HashMap());
        this.doubleKeyConfigMap.get(genBuilderClass).put(superTypeClass, configDtoSupplier);
    }

    public IConfigDto getConfig(Class<?> builderClass) {
        IConfigDto configDto = null;
        if (this.configMap.containsKey(builderClass)) {
            configDto = this.configMap.get(builderClass).get();
        }
        return configDto;
    }

    public IConfigDto getConfig(Class<?> builderClass, Class<?> generatedType) {
        IConfigDto configDto = null;
        if (this.configMap.containsKey(builderClass)) {
            configDto = this.configMap.get(builderClass).get();
        }
        if (this.doubleKeyConfigMap.containsKey(builderClass)) {
            Map<Class<?>, Supplier<IConfigDto>> classIConfigDtoMap = this.doubleKeyConfigMap.get(builderClass);
            for (Map.Entry<Class<?>, Supplier<IConfigDto>> generatedSuperType : classIConfigDtoMap.entrySet()) {
                if (!generatedSuperType.getKey().isAssignableFrom(generatedType)) continue;
                if (configDto != null) {
                    throw new DtoGeneratorException("Ambiguous generator's builder config.  Found more than one config for generated type: '" + generatedType + "'");
                }
                configDto = generatedSuperType.getValue().get();
            }
        }
        return configDto;
    }

    public StringGenerator.ConfigDto getStringConfig() {
        IConfigDto config = this.getConfig(StringGenerator.StringGeneratorBuilder.class);
        if (config == null) {
            config = new StringGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (StringGenerator.ConfigDto)config;
    }

    public IntegerGenerator.ConfigDto getIntegerConfig() {
        IConfigDto config = this.getConfig(IntegerGenerator.IntegerGeneratorBuilder.class);
        if (config == null) {
            config = new IntegerGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (IntegerGenerator.ConfigDto)config;
    }

    public LongGenerator.ConfigDto getLongConfig() {
        IConfigDto config = this.getConfig(LongGenerator.LongGeneratorBuilder.class);
        if (config == null) {
            config = new LongGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (LongGenerator.ConfigDto)this.getConfig(LongGenerator.LongGeneratorBuilder.class);
    }

    public DoubleGenerator.ConfigDto getDoubleConfig() {
        IConfigDto config = this.getConfig(DoubleGenerator.DoubleGeneratorBuilder.class);
        if (config == null) {
            config = new DoubleGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (DoubleGenerator.ConfigDto)config;
    }

    public LocalDateTimeGenerator.ConfigDto getLocalDateTimeConfig() {
        IConfigDto config = this.getConfig(LocalDateTimeGenerator.LocalDateTimeGeneratorBuilder.class);
        if (config == null) {
            config = new LocalDateTimeGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (LocalDateTimeGenerator.ConfigDto)config;
    }

    public EnumGenerator.ConfigDto getEnumConfig() {
        IConfigDto config = this.getConfig(EnumGenerator.EnumGeneratorBuilder.class);
        if (config == null) {
            config = new EnumGenerator.ConfigDto();
            this.setConfig(config);
        }
        return (EnumGenerator.ConfigDto)this.getConfig(EnumGenerator.EnumGeneratorBuilder.class);
    }

    public CollectionGenerator.ConfigDto getListConfig() {
        IConfigDto config = this.getConfig(CollectionGenerator.CollectionGeneratorBuilder.class, List.class);
        if (config == null) {
            config = new CollectionGenerator.ConfigDto();
            this.setCollectionConfig(List.class, config);
        }
        return (CollectionGenerator.ConfigDto)config;
    }

    public CollectionGenerator.ConfigDto getSetConfig() {
        IConfigDto config = this.getConfig(CollectionGenerator.CollectionGeneratorBuilder.class, Set.class);
        if (config == null) {
            config = new CollectionGenerator.ConfigDto();
            this.setCollectionConfig(Set.class, config);
        }
        return (CollectionGenerator.ConfigDto)config;
    }

    public Map<Class<? extends IGeneratorBuilder>, Supplier<IConfigDto>> getConfigMap() {
        return this.configMap;
    }

    public Map<Class<? extends IGeneratorBuilder>, Map<Class<?>, Supplier<IConfigDto>>> getDoubleKeyConfigMap() {
        return this.doubleKeyConfigMap;
    }
}

