/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import java.util.Objects;
import org.laoruga.dtogenerator.config.TypeGeneratorBuildersConfig;
import org.laoruga.dtogenerator.rules.RulesInstance;
import org.laoruga.dtogenerator.typegenerators.CollectionGenerator;
import org.laoruga.dtogenerator.typegenerators.DoubleGenerator;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.typegenerators.IntegerGenerator;
import org.laoruga.dtogenerator.typegenerators.LocalDateTimeGenerator;
import org.laoruga.dtogenerator.typegenerators.LongGenerator;
import org.laoruga.dtogenerator.typegenerators.StringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeGeneratorBuildersDefaultConfig
extends TypeGeneratorBuildersConfig {
    private static final Logger log = LoggerFactory.getLogger(TypeGeneratorBuildersDefaultConfig.class);
    private static final TypeGeneratorBuildersDefaultConfig instance = new TypeGeneratorBuildersDefaultConfig();

    private TypeGeneratorBuildersDefaultConfig() {
        this.setConfig(StringGenerator.StringGeneratorBuilder.class, () -> new StringGenerator.ConfigDto(RulesInstance.stringRule));
        this.setConfig(IntegerGenerator.IntegerGeneratorBuilder.class, () -> new IntegerGenerator.ConfigDto(RulesInstance.integerRule));
        this.setConfig(LongGenerator.LongGeneratorBuilder.class, () -> new LongGenerator.ConfigDto(RulesInstance.longRule));
        this.setConfig(DoubleGenerator.DoubleGeneratorBuilder.class, () -> new DoubleGenerator.ConfigDto(RulesInstance.doubleRule));
        this.setConfig(LocalDateTimeGenerator.LocalDateTimeGeneratorBuilder.class, () -> new LocalDateTimeGenerator.ConfigDto(RulesInstance.localDateTimeRule));
        this.setConfig(EnumGenerator.EnumGeneratorBuilder.class, () -> new EnumGenerator.ConfigDto(RulesInstance.enumRule));
        this.setCollectionConfig(RulesInstance.listRule.generatedType(), () -> new CollectionGenerator.ConfigDto(RulesInstance.listRule));
        this.setCollectionConfig(RulesInstance.setRule.generatedType(), () -> new CollectionGenerator.ConfigDto(RulesInstance.setRule));
    }

    @Override
    public IConfigDto getConfig(Class<?> builderClass) {
        return Objects.requireNonNull(super.getConfig(builderClass), "Default config not set for builder's class: '" + builderClass + "'");
    }

    @Override
    public IConfigDto getConfig(Class<?> builderClass, Class<?> generatedType) {
        return Objects.requireNonNull(super.getConfig(builderClass, generatedType), "Default config not set for builder's class: '" + builderClass + "' and field type: '" + generatedType + "'");
    }

    @Override
    public void setConfig(IConfigDto configDto) {
        super.setConfig(configDto);
        TypeGeneratorBuildersDefaultConfig.logWarning();
    }

    @Override
    public void setCollectionConfig(Class<?> superTypeClass, IConfigDto configDto) {
        super.setCollectionConfig(superTypeClass, configDto);
        TypeGeneratorBuildersDefaultConfig.logWarning();
    }

    private static void logWarning() {
        log.warn("Default type generator's config have changed, this may conclude to unexpected behaviour.");
    }

    public static TypeGeneratorBuildersDefaultConfig getInstance() {
        return instance;
    }
}

