/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import com.mifmif.common.regex.Generex;
import java.util.Arrays;
import java.util.Objects;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringGenerator
implements IGenerator<String> {
    private static final Logger log = LoggerFactory.getLogger(StringGenerator.class);
    private final int maxLength;
    private final int minLength;
    private final char[] chars;
    private final String[] words;
    private final IRuleRemark ruleRemark;
    private final String regexp;

    @Override
    public String generate() {
        int length;
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            length = this.minLength;
        } else if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            length = this.maxLength;
        } else if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            length = RandomUtils.nextInt(this.minLength, this.maxLength);
        } else {
            if (this.ruleRemark == RuleRemark.NULL_VALUE) {
                return null;
            }
            throw new IllegalStateException("Unexpected value " + this.ruleRemark);
        }
        if (this.words.length != 0) {
            return this.getRandomWord();
        }
        if (this.regexp != null && !this.regexp.isEmpty()) {
            return this.generateStringByRegexp();
        }
        return this.generateString(length);
    }

    private String generateString(int length) {
        return RandomUtils.nextString(this.chars, length);
    }

    private String generateStringByRegexp() {
        return new Generex(this.regexp).random(this.minLength, this.maxLength);
    }

    private String getRandomWord() {
        String randomItemFromList = RandomUtils.getRandomItem(this.words);
        if (this.maxLength < randomItemFromList.length()) {
            randomItemFromList = randomItemFromList.substring(0, this.maxLength);
        }
        return randomItemFromList;
    }

    public static StringGeneratorBuilder builder() {
        return new StringGeneratorBuilder();
    }

    public StringGenerator(int maxLength, int minLength, char[] chars, String[] words, IRuleRemark ruleRemark, String regexp) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.chars = chars;
        this.words = words;
        this.ruleRemark = ruleRemark;
        this.regexp = regexp;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Integer maxLength;
        private Integer minLength;
        private String[] words;
        private String chars;
        private IRuleRemark ruleRemark;
        private String regexp;

        public ConfigDto(StringRule stringRule) {
            this.maxLength = stringRule.maxLength();
            this.minLength = stringRule.minLength();
            this.words = stringRule.words();
            this.chars = stringRule.chars();
            this.ruleRemark = stringRule.ruleRemark();
            this.regexp = stringRule.regexp();
        }

        public ConfigDto() {
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return StringGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto configDto = (ConfigDto)from;
            if (configDto.getMaxLength() != null) {
                this.maxLength = configDto.getMaxLength();
            }
            if (configDto.getMinLength() != null) {
                this.minLength = configDto.getMinLength();
            }
            if (configDto.getWords() != null) {
                this.words = configDto.getWords();
            }
            if (configDto.getChars() != null) {
                this.chars = configDto.getChars();
            }
            if (configDto.getRuleRemark() != null) {
                this.ruleRemark = configDto.getRuleRemark();
            }
            if (configDto.getRegexp() != null) {
                this.regexp = configDto.getRegexp();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public String[] getWords() {
            return this.words;
        }

        public String getChars() {
            return this.chars;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        public void setWords(String[] words) {
            this.words = words;
        }

        public void setChars(String chars) {
            this.chars = chars;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        public ConfigDto(Integer maxLength, Integer minLength, String[] words, String chars, IRuleRemark ruleRemark, String regexp) {
            this.maxLength = maxLength;
            this.minLength = minLength;
            this.words = words;
            this.chars = chars;
            this.ruleRemark = ruleRemark;
            this.regexp = regexp;
        }

        static /* synthetic */ String[] access$302(ConfigDto x0, String[] x1) {
            x0.words = x1;
            return x1;
        }

        public static class ConfigDtoBuilder {
            private Integer maxLength;
            private Integer minLength;
            private String[] words;
            private String chars;
            private IRuleRemark ruleRemark;
            private String regexp;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ConfigDtoBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public ConfigDtoBuilder words(String[] words) {
                this.words = words;
                return this;
            }

            public ConfigDtoBuilder chars(String chars) {
                this.chars = chars;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDtoBuilder regexp(String regexp) {
                this.regexp = regexp;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.maxLength, this.minLength, this.words, this.chars, this.ruleRemark, this.regexp);
            }

            public String toString() {
                return "StringGenerator.ConfigDto.ConfigDtoBuilder(maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", words=" + Arrays.deepToString(this.words) + ", chars=" + this.chars + ", ruleRemark=" + this.ruleRemark + ", regexp=" + this.regexp + ")";
            }
        }
    }

    public static final class StringGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        private final ConfigDto configDto = new ConfigDto();

        private StringGeneratorBuilder() {
        }

        public StringGeneratorBuilder maxLength(int maxLength) {
            this.configDto.maxLength = maxLength;
            return this;
        }

        public StringGeneratorBuilder minLength(int minLength) {
            this.configDto.minLength = minLength;
            return this;
        }

        public StringGeneratorBuilder words(String[] words) {
            ConfigDto.access$302(this.configDto, words);
            return this;
        }

        public StringGeneratorBuilder chars(String chars) {
            this.configDto.chars = chars;
            return this;
        }

        public StringGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public StringGeneratorBuilder regexp(String regexp) {
            this.configDto.regexp = regexp;
            return this;
        }

        public StringGenerator build() {
            return this.build(this.configDto, false);
        }

        public StringGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto stringConfigDto = (ConfigDto)configDto;
            return new StringGenerator(stringConfigDto.maxLength, stringConfigDto.minLength, stringConfigDto.chars.toCharArray(), stringConfigDto.words, Objects.requireNonNull(stringConfigDto.ruleRemark, "Rule remark not set."), stringConfigDto.regexp);
        }
    }
}

