/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.executors;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.laoruga.dtogenerator.ErrorsHolder;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGeneratorsExecutor {
    private static final Logger log = LoggerFactory.getLogger(BatchGeneratorsExecutor.class);
    private final Map<Field, IGenerator<?>> fieldGeneratorMap;
    private final AbstractExecutor executorsChain;
    private int maxAttempts;
    private final ErrorsHolder errorsHolder = new ErrorsHolder();

    public BatchGeneratorsExecutor(AbstractExecutor executorsChain, Map<Field, IGenerator<?>> fieldGeneratorMap, int maxAttempts) {
        this.fieldGeneratorMap = fieldGeneratorMap;
        this.executorsChain = executorsChain;
        this.maxAttempts = maxAttempts;
    }

    public void execute() {
        boolean areAllCompleted = this.fieldGeneratorMap.isEmpty();
        int attempt = 0;
        while (!areAllCompleted && this.maxAttempts > attempt) {
            areAllCompleted = this.executeEachRemaining(++attempt);
        }
        if (!this.checkIfAllGeneratorsExecuted()) {
            log.error("{} error(s) while generators execution. See problems below: \n" + this.errorsHolder, (Object)this.errorsHolder.size());
            throw new DtoGeneratorException("Error while generators execution");
        }
    }

    private boolean executeEachRemaining(int attempt) {
        Iterator<Map.Entry<Field, IGenerator<?>>> iterator = this.fieldGeneratorMap.entrySet().iterator();
        while (iterator.hasNext() && this.maxAttempts > attempt) {
            boolean completed;
            Map.Entry<Field, IGenerator<?>> nextGenerator = iterator.next();
            Field field = nextGenerator.getKey();
            try {
                completed = this.executorsChain.execute(field, nextGenerator.getValue());
            }
            catch (Exception e) {
                ++attempt;
                this.errorsHolder.put(field, e);
                completed = false;
            }
            if (!completed) continue;
            iterator.remove();
        }
        return this.fieldGeneratorMap.isEmpty();
    }

    private boolean checkIfAllGeneratorsExecuted() {
        boolean successful = this.fieldGeneratorMap.isEmpty();
        if (!successful) {
            AtomicInteger counter = new AtomicInteger(0);
            String leftGenerators = this.fieldGeneratorMap.entrySet().stream().map(i -> counter.incrementAndGet() + ". Field: '" + i.getKey() + "', generator: '" + i.getValue() + "'").collect(Collectors.joining("\n"));
            log.error("Unexpected state. There {} unused generator(s) left:\n" + leftGenerators, (Object)this.fieldGeneratorMap.size());
        }
        if (!this.errorsHolder.isEmpty()) {
            log.warn("{} error(s) while generators execution:\n" + this.errorsHolder, (Object)this.errorsHolder.size());
        }
        return successful;
    }
}

