/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.executors;

import java.lang.reflect.Field;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorOfGenerator
extends AbstractExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOfGenerator.class);
    private final Object dtoInstance;

    public <T> ExecutorOfGenerator(T dtoInstance) {
        super(null);
        this.dtoInstance = dtoInstance;
    }

    @Override
    public boolean execute(Field field, IGenerator<?> generator) {
        Object result;
        try {
            result = generator.generate();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while generating value for the field: " + field, e);
        }
        try {
            field.setAccessible(true);
            field.set(this.dtoInstance, result);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while setting generated value of type: '" + (result != null ? result.getClass() : null) + "' to the field: '" + field + "'", e);
        }
        return true;
    }
}

