/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.providers;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.TypeGeneratorsProvider;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.config.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.CollectionGenerator;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;

public abstract class AbstractGeneratorBuildersProvider {
    private final DtoGeneratorInstanceConfig configuration;
    private AbstractGeneratorBuildersProvider nextProvider;
    private volatile IRuleRemark maybeRemark;

    protected AbstractGeneratorBuildersProvider(DtoGeneratorInstanceConfig configuration) {
        this.configuration = configuration;
    }

    public void addNextProvider(AbstractGeneratorBuildersProvider provider) {
        this.nextProvider = provider;
    }

    public Optional<AbstractGeneratorBuildersProvider> getNextProvider() {
        return Optional.ofNullable(this.nextProvider);
    }

    protected DtoGeneratorInstanceConfig getConfiguration() {
        return this.configuration;
    }

    abstract Optional<IGenerator<?>> selectOrCreateGenerator();

    public Optional<IGenerator<?>> getGenerator() {
        Optional<IGenerator<?>> maybeGenerator = this.selectOrCreateGenerator();
        if (maybeGenerator.isPresent()) {
            return maybeGenerator;
        }
        Optional<AbstractGeneratorBuildersProvider> provider = this.getNextProvider();
        if (provider.isPresent()) {
            return provider.get().getGenerator();
        }
        return Optional.empty();
    }

    public void accept(TypeGeneratorsProvider.ProvidersVisitor visitor) {
        visitor.visit(this);
        if (this.getNextProvider().isPresent()) {
            this.getNextProvider().get().accept(visitor);
        }
    }

    public IRuleRemark getRuleRemark() {
        return this.maybeRemark;
    }

    public void setMaybeRemark(IRuleRemark maybeRemark) {
        this.maybeRemark = maybeRemark;
    }

    protected IGenerator<?> getGenerator(Supplier<IConfigDto> configDtoSupplier, Supplier<IGeneratorBuilderConfigurable> genBuildSupplier, BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> generatorSupplier, Class<?> fieldType) {
        IGeneratorBuilderConfigurable genBuilder = genBuildSupplier.get();
        IConfigDto instanceConfig = this.getConfiguration().getGenBuildersConfig().getConfig(genBuilder.getClass(), fieldType);
        IConfigDto staticConfig = DtoGeneratorStaticConfig.getInstance().getGenBuildersConfig().getConfig(genBuilder.getClass(), fieldType);
        IConfigDto config = configDtoSupplier.get();
        if (staticConfig != null) {
            config.merge(staticConfig);
        }
        if (instanceConfig != null) {
            config.merge(instanceConfig);
        }
        if (this.getRuleRemark() != null) {
            config.setRuleRemark(this.getRuleRemark());
        }
        return generatorSupplier.apply(config, genBuilder);
    }

    protected BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> enumGeneratorSupplier(Class<?> generatedType) {
        return (config, builder) -> {
            EnumGenerator.ConfigDto enumConfig = (EnumGenerator.ConfigDto)config;
            if (enumConfig.getEnumClass() == null) {
                if (generatedType.isEnum()) {
                    enumConfig.setEnumClass(generatedType);
                } else {
                    throw new DtoGeneratorException("Field type must be enum : '" + generatedType + "'");
                }
            }
            return ((EnumGenerator.EnumGeneratorBuilder)builder).build((IConfigDto)config, true);
        };
    }

    protected BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> collectionGeneratorSupplier(IGenerator<?> elementGenerator) {
        return (config, builder) -> {
            ((CollectionGenerator.ConfigDto)config).setElementGenerator(elementGenerator);
            return builder.build((IConfigDto)config, true);
        };
    }
}

