/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.text.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomUtils {
    private static final Logger log = LoggerFactory.getLogger(RandomUtils.class);
    private static final RandomStringGenerator DEFAULT_STRING_GENERATOR = new RandomStringGenerator.Builder().selectFrom("1234567890qwertzuiopasdfghjklyxcvbnQWERTZUIOPASDFGHJKLYXCVBNM~\"`'.,!?@#\u2116$%^-+=*(){}[]/|\\_:; ".toCharArray()).build();
    private static final Random random = new Random();

    public static Double nextDouble(int minNumber, int maxNumber) {
        double floatPart = random.nextDouble();
        int integerPart = RandomUtils.nextInt(minNumber, maxNumber);
        return integerPart == maxNumber ? (double)maxNumber : (double)integerPart + floatPart;
    }

    public static Integer nextInt(int minNumber, int maxNumber) {
        return random.nextInt(maxNumber - minNumber + 1) + minNumber;
    }

    public static Integer nextInt(String minNumber, String maxNumber) {
        return RandomUtils.nextInt(Integer.parseInt(minNumber), Integer.parseInt(maxNumber));
    }

    public static boolean nextBoolean() {
        return RandomUtils.nextInt(0, 1) == 1;
    }

    public static <T> T getRandomItem(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        int randomIdx = RandomUtils.nextInt(0, collection.size() - 1);
        T result = iterator.next();
        for (int idx = 0; iterator.hasNext() && randomIdx != idx; ++idx) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T getRandomItem(T ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Empty array passed");
        }
        return items[RandomUtils.nextInt(0, items.length - 1)];
    }

    public static long nextLong(long minNumber, long maxNumber) {
        if (minNumber == maxNumber) {
            return minNumber;
        }
        return ThreadLocalRandom.current().nextLong(minNumber, maxNumber);
    }

    public static String nextString(char[] chars, int length) {
        return new RandomStringGenerator.Builder().selectFrom(chars).build().generate(length);
    }

    public static String nextString(int length) {
        return DEFAULT_STRING_GENERATOR.generate(length);
    }

    private RandomUtils() {
    }

    public static Random getRandom() {
        return random;
    }
}

