/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.examples.generators.custom;

import java.util.Optional;
import org.laoruga.dtogenerator.DtoGenerator;
import org.laoruga.dtogenerator.api.generators.AbstractCustomGeneratorRemarkable;
import org.laoruga.dtogenerator.api.remarks.CustomRuleRemarkWrapper;
import org.laoruga.dtogenerator.examples.dto.Gender;
import org.laoruga.dtogenerator.examples.dto.Person;
import org.laoruga.dtogenerator.examples.generators.custom.remark.PersonRemark;
import org.laoruga.dtogenerator.util.RandomUtils;

public class CustomGeneratorRemarkable
extends AbstractCustomGeneratorRemarkable<Person> {
    public Person generate() {
        Person person = (Person)DtoGenerator.builder(Person.class).build().generateDto();
        Optional maybeAgeRemark = this.getWrappedRemark(PersonRemark.AGE_RANGE);
        Optional maybeWeightRemark = this.getWrappedRemark(PersonRemark.WEIGHT_RANGE);
        Optional maybeGrowthRemark = this.getWrappedRemark(PersonRemark.GROWTH_RANGE);
        Optional maybeGenderRemark = this.getWrappedRemark(PersonRemark.GENDER);
        maybeAgeRemark.ifPresent(ruleRemarkWrapper -> person.setAge(CustomGeneratorRemarkable.randomInRange(ruleRemarkWrapper)));
        maybeWeightRemark.ifPresent(ruleRemarkWrapper -> person.setWeight(CustomGeneratorRemarkable.randomInRange(ruleRemarkWrapper)));
        maybeGrowthRemark.ifPresent(ruleRemarkWrapper -> person.setGrowth(CustomGeneratorRemarkable.randomInRange(ruleRemarkWrapper)));
        maybeGenderRemark.ifPresent(ruleRemarkWrapper -> person.setGender(Gender.valueOf(ruleRemarkWrapper.getArgs()[0])));
        return person;
    }

    private static int randomInRange(CustomRuleRemarkWrapper ruleRemarkWrapper) {
        String[] range = ruleRemarkWrapper.getArgs();
        return RandomUtils.nextInt((String)range[0], (String)range[1]);
    }
}

