/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.examples.generators.custom;

import java.util.Map;
import java.util.Optional;
import org.laoruga.dtogenerator.DtoGenerator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorConfigMap;
import org.laoruga.dtogenerator.examples.dto.Gender;
import org.laoruga.dtogenerator.examples.dto.Person;
import org.laoruga.dtogenerator.examples.generators.custom.remark.PersonRemark;
import org.laoruga.dtogenerator.util.RandomUtils;

public class CustomGeneratorRemarkable
implements CustomGeneratorConfigMap<Person> {
    Map<String, String> configMap;

    public Person generate() {
        Person person = (Person)DtoGenerator.builder(Person.class).build().generateDto();
        Optional<String> maybeMinAge = Optional.ofNullable(this.configMap.get(PersonRemark.MIN_AGE.name()));
        Optional<String> maybeMaxAge = Optional.ofNullable(this.configMap.get(PersonRemark.MAX_AGE.name()));
        Optional<String> maybeMinWeight = Optional.ofNullable(this.configMap.get(PersonRemark.MIN_WEIGHT.name()));
        Optional<String> maybeMaxWeight = Optional.ofNullable(this.configMap.get(PersonRemark.MAX_WEIGHT.name()));
        Optional<String> maybeMinGrowth = Optional.ofNullable(this.configMap.get(PersonRemark.MIN_GROWTH.name()));
        Optional<String> maybeMaxGrowth = Optional.ofNullable(this.configMap.get(PersonRemark.MAX_GROWTH.name()));
        Optional<String> maybeGenderRemark = Optional.ofNullable(this.configMap.get(PersonRemark.GENDER.name()));
        person.setAge(RandomUtils.nextInt((String)maybeMinAge.orElse("1"), (String)maybeMaxAge.orElse("99")));
        person.setWeight(RandomUtils.nextInt((String)maybeMinWeight.orElse("5"), (String)maybeMaxWeight.orElse("250")));
        person.setGrowth(RandomUtils.nextInt((String)maybeMinGrowth.orElse("18"), (String)maybeMaxGrowth.orElse("85")));
        person.setGender(maybeGenderRemark.map(Gender::valueOf).orElse((Gender)((Object)RandomUtils.getRandomItem((Object[])Gender.values()))));
        return person;
    }

    public void setConfigMap(Map<String, String> configMap) {
        this.configMap = configMap;
    }
}

