/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.examples.generators.custom;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.text.RandomStringGenerator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorArgs;

public class CustomGeneratorWithArgs
implements CustomGeneratorArgs<List<String>> {
    Args args;

    public void setArgs(String ... args) {
        this.args = this.convert(args);
    }

    public List<String> generate() {
        return IntStream.range(0, this.args.size).boxed().map(i -> new RandomStringGenerator.Builder().selectFrom(this.args.charset).build().generate(0, this.args.maxLength)).collect(Collectors.toList());
    }

    private Args convert(String ... args) {
        Args params;
        try {
            int size = Integer.parseInt(args[0]);
            int maxLength = Integer.parseInt(args[1]);
            char[] charset = args[2].toCharArray();
            params = new Args(size, maxLength, charset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Two arguments must be passed, but was: " + Arrays.asList(args));
        }
        if (params.size <= 0) {
            throw new IllegalArgumentException("First argument must be more then 0, but was: " + params.size);
        }
        return params;
    }

    private static class Args {
        int size;
        int maxLength;
        char[] charset;

        public Args(int size, int maxLength, char[] charset) {
            this.size = size;
            this.maxLength = maxLength;
            this.charset = charset;
        }
    }
}

