/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.laoruga.dtogenerator.DtoGeneratorBuilder;
import org.laoruga.dtogenerator.ErrorsHolder;
import org.laoruga.dtogenerator.TypeGeneratorsProvider;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.config.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.executors.BatchGeneratorsExecutor;
import org.laoruga.dtogenerator.typegenerators.executors.ExecutorOfCollectionGenerator;
import org.laoruga.dtogenerator.typegenerators.executors.ExecutorOfDtoDependentGenerator;
import org.laoruga.dtogenerator.typegenerators.executors.ExecutorOfGenerator;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoGenerator<T> {
    private static final Logger log = LoggerFactory.getLogger(DtoGenerator.class);
    private final T dtoInstance;
    private final TypeGeneratorsProvider<T> typeGeneratorsProvider;
    private final Map<Field, IGenerator<?>> fieldGeneratorMap = new LinkedHashMap();
    private final DtoGeneratorBuilder<T> builderInstance;
    private final ErrorsHolder errorsHolder = new ErrorsHolder();

    protected DtoGenerator(TypeGeneratorsProvider<T> typeGeneratorsProvider, DtoGeneratorBuilder<T> dtoGeneratorBuilder) {
        this.typeGeneratorsProvider = typeGeneratorsProvider;
        this.builderInstance = dtoGeneratorBuilder;
        this.dtoInstance = typeGeneratorsProvider.getDtoInstance();
    }

    public static <T> DtoGeneratorBuilder<T> builder(Class<T> dtoClass) {
        return new DtoGeneratorBuilder<T>(ReflectionUtils.createInstance(dtoClass));
    }

    public static <T> DtoGeneratorBuilder<T> builder(T dtoInstance) {
        return new DtoGeneratorBuilder<T>(dtoInstance);
    }

    public T generateDto() {
        this.prepareGeneratorsRecursively(this.dtoInstance.getClass());
        this.applyGenerators();
        return this.dtoInstance;
    }

    private void prepareGeneratorsRecursively(Class<?> dtoClass) {
        if (dtoClass.getSuperclass() != null) {
            this.prepareGeneratorsRecursively(dtoClass.getSuperclass());
        }
        this.prepareGenerators(dtoClass);
    }

    void applyGenerators() {
        int maxAttempts = DtoGeneratorStaticConfig.getInstance().getMaxDependentGenerationCycles();
        ExecutorOfDtoDependentGenerator executorsChain = new ExecutorOfDtoDependentGenerator(new ExecutorOfCollectionGenerator(new ExecutorOfGenerator(this.dtoInstance)));
        BatchGeneratorsExecutor batchGeneratorsExecutor = new BatchGeneratorsExecutor(executorsChain, this.getFieldGeneratorMap(), maxAttempts);
        batchGeneratorsExecutor.execute();
    }

    void prepareGenerators(Class<?> dtoClass) {
        for (Field field : dtoClass.getDeclaredFields()) {
            Optional<Object> generator = Optional.empty();
            try {
                generator = this.getTypeGeneratorsProvider().getGenerator(field);
            }
            catch (Exception e) {
                this.errorsHolder.put(field, e);
            }
            generator.ifPresent(iGenerator -> this.getFieldGeneratorMap().put(field, (IGenerator<?>)iGenerator));
        }
        if (!this.errorsHolder.isEmpty()) {
            log.error("{} error(s) while generators preparation. See problems below: \n" + this.errorsHolder, (Object)this.errorsHolder.size());
            throw new DtoGeneratorException("Error while generators preparation (see log above)");
        }
        if (this.getFieldGeneratorMap().isEmpty()) {
            log.debug("Generators not found");
        } else {
            AtomicInteger idx = new AtomicInteger(0);
            log.debug(this.getFieldGeneratorMap().size() + " generators created for fields: \n" + this.getFieldGeneratorMap().keySet().stream().map(i -> idx.incrementAndGet() + ". " + i).collect(Collectors.joining("\n")));
        }
    }

    TypeGeneratorsProvider<T> getTypeGeneratorsProvider() {
        return this.typeGeneratorsProvider;
    }

    Map<Field, IGenerator<?>> getFieldGeneratorMap() {
        return this.fieldGeneratorMap;
    }

    DtoGeneratorBuilder<T> getBuilderInstance() {
        return this.builderInstance;
    }
}

