/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import org.laoruga.dtogenerator.config.DtoGeneratorConfig;
import org.laoruga.dtogenerator.config.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.config.TypeGeneratorBuildersConfig;

public class DtoGeneratorInstanceConfig {
    private final DtoGeneratorConfig staticConfig = DtoGeneratorStaticConfig.getInstance();
    private final DtoGeneratorConfig instanceConfig = new DtoGeneratorConfig();

    public void setMaxDependentGenerationCycles(Integer maxDependentGenerationCycles) {
        this.instanceConfig.setMaxDependentGenerationCycles(maxDependentGenerationCycles);
    }

    public void setMaxCollectionGenerationCycles(Integer maxCollectionGenerationCycles) {
        this.instanceConfig.setMaxCollectionGenerationCycles(maxCollectionGenerationCycles);
    }

    public void setGenerateAllKnownTypes(Boolean generateAllKnownTypes) {
        this.instanceConfig.setGenerateAllKnownTypes(generateAllKnownTypes);
    }

    public Integer getMaxDependentGenerationCycles() {
        return this.getOrDefault(this.instanceConfig.getMaxDependentGenerationCycles(), this.staticConfig.getMaxDependentGenerationCycles());
    }

    public Integer getMaxCollectionGenerationCycles() {
        return this.getOrDefault(this.instanceConfig.getMaxCollectionGenerationCycles(), this.staticConfig.getMaxCollectionGenerationCycles());
    }

    public Boolean getGenerateAllKnownTypes() {
        return this.getOrDefault(this.instanceConfig.getGenerateAllKnownTypes(), this.staticConfig.getGenerateAllKnownTypes());
    }

    public TypeGeneratorBuildersConfig getGenBuildersConfig() {
        return this.instanceConfig.getGenBuildersConfig();
    }

    private <T> T getOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

