/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;
import org.laoruga.dtogenerator.api.rules.CustomRule;
import org.laoruga.dtogenerator.api.rules.DoubleRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegerRule;
import org.laoruga.dtogenerator.api.rules.ListRule;
import org.laoruga.dtogenerator.api.rules.LocalDateTimeRule;
import org.laoruga.dtogenerator.api.rules.LongRule;
import org.laoruga.dtogenerator.api.rules.NestedDtoRule;
import org.laoruga.dtogenerator.api.rules.SetRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public final class RulesInstance {
    @StringRule
    @IntegerRule
    @LongRule
    @DoubleRule
    @EnumRule
    @LocalDateTimeRule
    @ListRule
    @SetRule
    @CustomRule(generatorClass=Object.class)
    @NestedDtoRule
    private static Object annotations;
    public static final StringRule stringRule;
    public static final IntegerRule integerRule;
    public static final LongRule longRule;
    public static final EnumRule enumRule;
    public static final DoubleRule doubleRule;
    public static final LocalDateTimeRule localDateTimeRule;
    public static final SetRule setRule;
    public static final ListRule listRule;
    public static final CustomRule customRule;
    public static final NestedDtoRule nestedDtoRule;

    private static <T extends Annotation> T getAnnotationInstance(Field field, Class<T> annotationClass) {
        return (T)((Annotation)Objects.requireNonNull(field.getDeclaredAnnotation(annotationClass), "Annotation instance was not set for class: '" + annotationClass + "'"));
    }

    private RulesInstance() {
    }

    static {
        try {
            Field annotations = RulesInstance.class.getDeclaredField("annotations");
            stringRule = RulesInstance.getAnnotationInstance(annotations, StringRule.class);
            integerRule = RulesInstance.getAnnotationInstance(annotations, IntegerRule.class);
            longRule = RulesInstance.getAnnotationInstance(annotations, LongRule.class);
            enumRule = RulesInstance.getAnnotationInstance(annotations, EnumRule.class);
            doubleRule = RulesInstance.getAnnotationInstance(annotations, DoubleRule.class);
            localDateTimeRule = RulesInstance.getAnnotationInstance(annotations, LocalDateTimeRule.class);
            setRule = RulesInstance.getAnnotationInstance(annotations, SetRule.class);
            listRule = RulesInstance.getAnnotationInstance(annotations, ListRule.class);
            customRule = RulesInstance.getAnnotationInstance(annotations, CustomRule.class);
            nestedDtoRule = RulesInstance.getAnnotationInstance(annotations, NestedDtoRule.class);
        }
        catch (NoSuchFieldException e) {
            throw new DtoGeneratorException(e);
        }
    }
}

