/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.LongRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;

public class LongGenerator
implements IGenerator<Long> {
    private final long maxValue;
    private final long minValue;
    private final IRuleRemark ruleRemark;

    @Override
    public Long generate() {
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            return this.minValue;
        }
        if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            return this.maxValue;
        }
        if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            return this.minValue + (long)(Math.random() * (double)(this.maxValue - this.minValue));
        }
        if (this.ruleRemark == RuleRemark.NULL_VALUE) {
            return null;
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public static LongGeneratorBuilder builder() {
        return new LongGeneratorBuilder();
    }

    public LongGenerator(long maxValue, long minValue, IRuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Long maxValue;
        private Long minValue;
        private IRuleRemark ruleRemark;

        public ConfigDto(LongRule rule) {
            this.maxValue = rule.maxValue();
            this.minValue = rule.minValue();
            this.ruleRemark = rule.ruleRemark();
        }

        public ConfigDto() {
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return LongGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto configDto = (ConfigDto)from;
            if (configDto.getMaxValue() != null) {
                this.maxValue = configDto.getMaxValue();
            }
            if (configDto.getMinValue() != null) {
                this.minValue = configDto.getMinValue();
            }
            if (configDto.getRuleRemark() != null) {
                this.ruleRemark = configDto.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public void setMaxValue(Long maxValue) {
            this.maxValue = maxValue;
        }

        public void setMinValue(Long minValue) {
            this.minValue = minValue;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public Long getMaxValue() {
            return this.maxValue;
        }

        public Long getMinValue() {
            return this.minValue;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public ConfigDto(Long maxValue, Long minValue, IRuleRemark ruleRemark) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.ruleRemark = ruleRemark;
        }

        public static class ConfigDtoBuilder {
            private Long maxValue;
            private Long minValue;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder maxValue(Long maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public ConfigDtoBuilder minValue(Long minValue) {
                this.minValue = minValue;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.maxValue, this.minValue, this.ruleRemark);
            }

            public String toString() {
                return "LongGenerator.ConfigDto.ConfigDtoBuilder(maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static final class LongGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        private final ConfigDto configDto = new ConfigDto();

        private LongGeneratorBuilder() {
        }

        public LongGeneratorBuilder maxValue(long maxValue) {
            this.configDto.maxValue = maxValue;
            return this;
        }

        public LongGeneratorBuilder minValue(long minValue) {
            this.configDto.minValue = minValue;
            return this;
        }

        public LongGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public LongGenerator build() {
            return this.build(this.configDto, false);
        }

        public LongGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto longConfigDto = (ConfigDto)configDto;
            return new LongGenerator(longConfigDto.maxValue, longConfigDto.minValue, longConfigDto.ruleRemark);
        }
    }
}

