/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.DtoGenerator;
import org.laoruga.dtogenerator.TypeGeneratorRemarksProvider;
import org.laoruga.dtogenerator.TypeGeneratorsProvider;
import org.laoruga.dtogenerator.api.generators.ICollectionGenerator;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGeneratorRemarkable;
import org.laoruga.dtogenerator.api.rules.CustomRule;
import org.laoruga.dtogenerator.api.rules.DoubleRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegerRule;
import org.laoruga.dtogenerator.api.rules.ListRule;
import org.laoruga.dtogenerator.api.rules.LocalDateTimeRule;
import org.laoruga.dtogenerator.api.rules.LongRule;
import org.laoruga.dtogenerator.api.rules.NestedDtoRule;
import org.laoruga.dtogenerator.api.rules.SetRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.rules.IRuleInfo;
import org.laoruga.dtogenerator.rules.RuleInfoCollection;
import org.laoruga.dtogenerator.typegenerators.CollectionGenerator;
import org.laoruga.dtogenerator.typegenerators.CustomGenerator;
import org.laoruga.dtogenerator.typegenerators.DoubleGenerator;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.typegenerators.IntegerGenerator;
import org.laoruga.dtogenerator.typegenerators.LocalDateTimeGenerator;
import org.laoruga.dtogenerator.typegenerators.LongGenerator;
import org.laoruga.dtogenerator.typegenerators.NestedDtoGenerator;
import org.laoruga.dtogenerator.typegenerators.StringGenerator;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersFactory;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersHolder;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersHolderGeneral;
import org.laoruga.dtogenerator.typegenerators.providers.AbstractGeneratorBuildersProvider;
import org.laoruga.dtogenerator.typegenerators.providers.GeneratorBuildersProviderByType;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorBuildersProviderByAnnotation
extends AbstractGeneratorBuildersProvider {
    private static final Logger log = LoggerFactory.getLogger(GeneratorBuildersProviderByAnnotation.class);
    private final GeneratorBuildersProviderByType generatorBuildersProviderByType;
    private final TypeGeneratorRemarksProvider typeGeneratorRemarksProvider;
    private final GeneratorBuildersHolder userGeneratorBuildersHolder;
    private final GeneratorBuildersHolder defaultGeneratorBuildersHolder = GeneratorBuildersHolderGeneral.getInstance();
    private volatile Field field;
    private volatile Object dtoInstance;
    private volatile IRuleInfo ruleInfo;
    private volatile Supplier<DtoGenerator<?>> nestedDtoGeneratorSupplier;
    private volatile Class<?> generatedTypeOrCollectionElementType;

    public GeneratorBuildersProviderByAnnotation(DtoGeneratorInstanceConfig configuration, GeneratorBuildersProviderByType generatorBuildersProviderByType, TypeGeneratorRemarksProvider typeGeneratorRemarksProvider, GeneratorBuildersHolder userGeneratorBuildersHolder) {
        super(configuration);
        this.generatorBuildersProviderByType = generatorBuildersProviderByType;
        this.typeGeneratorRemarksProvider = typeGeneratorRemarksProvider;
        this.userGeneratorBuildersHolder = userGeneratorBuildersHolder;
    }

    @Override
    public Optional<IGenerator<?>> selectOrCreateGenerator() {
        IGenerator<?> generator;
        if (this.ruleInfo.isTypesEqual(RuleType.COLLECTION)) {
            IGenerator<?> elementGenerator;
            IGeneratorBuilder collectionGenBuilder;
            this.generatedTypeOrCollectionElementType = ReflectionUtils.getSingleGenericType(this.field);
            RuleInfoCollection collectionRuleInfo = (RuleInfoCollection)this.ruleInfo;
            Optional<IGeneratorBuilder> maybeCollectionUserGenBuilder = this.getUsersGenBuilder(collectionRuleInfo.getRule(), this.getFieldType());
            boolean isUserCollectionBuilder = maybeCollectionUserGenBuilder.isPresent();
            IGeneratorBuilder iGeneratorBuilder = collectionGenBuilder = isUserCollectionBuilder ? maybeCollectionUserGenBuilder.get() : this.getDefaultGenBuilder(collectionRuleInfo.getRule(), this.getFieldType());
            if (collectionRuleInfo.isElementRulesExist()) {
                IRuleInfo elementRuleInfo = collectionRuleInfo.getElementRule();
                Optional<IGeneratorBuilder> maybeUsersElementGenBuilder = this.getUsersGenBuilder(elementRuleInfo.getRule(), this.generatedTypeOrCollectionElementType);
                boolean isUserBuilder = maybeUsersElementGenBuilder.isPresent();
                IGeneratorBuilder elementGenBuilder = isUserBuilder ? maybeUsersElementGenBuilder.get() : this.getDefaultGenBuilder(elementRuleInfo.getRule(), this.generatedTypeOrCollectionElementType);
                elementGenerator = this.buildGenerator(elementRuleInfo.getRule(), elementGenBuilder, false);
            } else {
                Optional<IGenerator<?>> maybeGenerator = this.generatorBuildersProviderByType.selectOrCreateGenerator(this.generatedTypeOrCollectionElementType);
                if (!maybeGenerator.isPresent()) {
                    throw new DtoGeneratorException("Collection element rules absent on the field, and element generator wasn't evaluated by type.");
                }
                elementGenerator = maybeGenerator.get();
            }
            this.prepareCustomRemarks(elementGenerator, this.getFieldName());
            generator = this.buildCollectionGenerator(collectionRuleInfo.getRule(), collectionGenBuilder, elementGenerator);
        } else {
            this.generatedTypeOrCollectionElementType = this.getFieldType();
            Optional<IGeneratorBuilder> maybeUsersGenBuilder = this.getUsersGenBuilder(this.ruleInfo.getRule(), this.getFieldType());
            boolean isUserBuilder = maybeUsersGenBuilder.isPresent();
            IGeneratorBuilder genBuilder = isUserBuilder ? maybeUsersGenBuilder.get() : this.getDefaultGenBuilder(this.ruleInfo.getRule(), this.getFieldType());
            generator = this.buildGenerator(this.ruleInfo.getRule(), genBuilder, this.generatedTypeOrCollectionElementType.isPrimitive());
        }
        this.prepareCustomRemarks(generator, this.getFieldName());
        return Optional.ofNullable(generator);
    }

    private IGeneratorBuilder getDefaultGenBuilder(Annotation rules, Class<?> generatedType) {
        return this.defaultGeneratorBuildersHolder.getBuilder(rules, generatedType).orElseThrow(() -> new DtoGeneratorException("General generator builder not found. Rules: '" + rules + "', Genrated type: '" + generatedType + "'"));
    }

    private Optional<IGeneratorBuilder> getUsersGenBuilder(Annotation rules, Class<?> generatedType) {
        return this.userGeneratorBuildersHolder.getBuilder(rules, generatedType);
    }

    private IGenerator<?> buildGenerator(Annotation rules, IGeneratorBuilder generatorBuilder, boolean isPrimitive) {
        block19: {
            Class<? extends Annotation> rulesClass = rules.annotationType();
            try {
                if (StringRule.class == rulesClass) {
                    if (generatorBuilder instanceof StringGenerator.StringGeneratorBuilder) {
                        return this.getGenerator(() -> new StringGenerator.ConfigDto((StringRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, (config, builder) -> builder.build((IConfigDto)config, true), this.getFieldType());
                    }
                    break block19;
                }
                if (DoubleRule.class == rulesClass) {
                    if (generatorBuilder instanceof DoubleGenerator.DoubleGeneratorBuilder) {
                        return this.getGenerator(() -> new DoubleGenerator.ConfigDto((DoubleRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, this.doubleGeneratorSupplier(isPrimitive), this.getFieldType());
                    }
                    break block19;
                }
                if (IntegerRule.class == rulesClass) {
                    if (generatorBuilder instanceof IntegerGenerator.IntegerGeneratorBuilder) {
                        return this.getGenerator(() -> new IntegerGenerator.ConfigDto((IntegerRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, this.integerGeneratorSupplier(isPrimitive), this.getFieldType());
                    }
                    break block19;
                }
                if (LongRule.class == rulesClass) {
                    if (generatorBuilder instanceof LongGenerator.LongGeneratorBuilder) {
                        return this.getGenerator(() -> new LongGenerator.ConfigDto((LongRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, this.longGeneratorSupplier(isPrimitive), this.getFieldType());
                    }
                    break block19;
                }
                if (EnumRule.class == rulesClass) {
                    if (generatorBuilder instanceof EnumGenerator.EnumGeneratorBuilder) {
                        return this.getGenerator(() -> new EnumGenerator.ConfigDto((EnumRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, this.enumGeneratorSupplier(this.generatedTypeOrCollectionElementType), this.getFieldType());
                    }
                    break block19;
                }
                if (LocalDateTimeRule.class == rulesClass) {
                    if (generatorBuilder instanceof LocalDateTimeGenerator.LocalDateTimeGeneratorBuilder) {
                        return this.getGenerator(() -> new LocalDateTimeGenerator.ConfigDto((LocalDateTimeRule)rules), () -> (IGeneratorBuilderConfigurable)generatorBuilder, (config, builder) -> builder.build((IConfigDto)config, true), this.getFieldType());
                    }
                    break block19;
                }
                if (CustomRule.class == rulesClass) {
                    if (generatorBuilder instanceof CustomGenerator.CustomGeneratorBuilder) {
                        return this.getCustomGenerator((CustomGenerator.CustomGeneratorBuilder)generatorBuilder, (CustomRule)rules);
                    }
                    break block19;
                }
                if (NestedDtoRule.class == rulesClass) {
                    if (generatorBuilder instanceof NestedDtoGenerator.NestedDtoGeneratorBuilder) {
                        return this.getNestedDtoGenerator((NestedDtoGenerator.NestedDtoGeneratorBuilder)generatorBuilder);
                    }
                    break block19;
                }
                throw new DtoGeneratorException("Unknown rules annotation '" + rulesClass + "'");
            }
            catch (Exception e) {
                if (e.getClass() == ClassCastException.class) {
                    log.debug("Probably unknown builder, trying to build generator as is.");
                    return generatorBuilder.build();
                }
                throw e;
            }
        }
        log.debug("Unknown generator builder, trying to build 'as is' without configuring.");
        return generatorBuilder.build();
    }

    private IGenerator<?> buildCollectionGenerator(Annotation collectionRule, IGeneratorBuilder collectionGenBuilder, IGenerator<?> elementGenerator) {
        Class<? extends Annotation> rulesClass = collectionRule.annotationType();
        if (collectionGenBuilder instanceof CollectionGenerator.CollectionGeneratorBuilder) {
            CollectionGenerator.ConfigDto configDto;
            if (ListRule.class == rulesClass) {
                configDto = new CollectionGenerator.ConfigDto((ListRule)collectionRule).setCollectionInstance(() -> ReflectionUtils.createCollectionInstance(((ListRule)collectionRule).listClass()));
            } else if (SetRule.class == rulesClass) {
                configDto = new CollectionGenerator.ConfigDto((SetRule)collectionRule).setCollectionInstance(() -> ReflectionUtils.createCollectionInstance(((SetRule)collectionRule).setClass()));
            } else {
                throw new DtoGeneratorException("Unknown rules annotation class '" + rulesClass + "'");
            }
            return this.getGenerator(() -> configDto, () -> (IGeneratorBuilderConfigurable)collectionGenBuilder, this.collectionGeneratorSupplier(elementGenerator), this.getFieldType());
        }
        log.debug("Unknown collection builder builds as is, without Rules annotation params passing.");
        return collectionGenBuilder.build();
    }

    private IGenerator<?> getCustomGenerator(CustomGenerator.CustomGeneratorBuilder builder, CustomRule rule) {
        return builder.setCustomGeneratorRules(rule).setDtoInstance(this.dtoInstance).build();
    }

    private IGenerator<?> getNestedDtoGenerator(NestedDtoGenerator.NestedDtoGeneratorBuilder builder) {
        return builder.setNestedDtoGeneratorSupplier(this.nestedDtoGeneratorSupplier).build();
    }

    BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> integerGeneratorSupplier(boolean isPrimitive) {
        return (config, builder) -> {
            if (config.getRuleRemark() == RuleRemark.NULL_VALUE && isPrimitive) {
                this.reportPrimitiveCannotBeNull();
                return GeneratorBuildersFactory.integerBuilder().minValue(0).maxValue(0).ruleRemark(RuleRemark.MIN_VALUE).build();
            }
            return builder.build((IConfigDto)config, true);
        };
    }

    BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> longGeneratorSupplier(boolean isPrimitive) {
        return (config, builder) -> {
            if (config.getRuleRemark() == RuleRemark.NULL_VALUE && isPrimitive) {
                this.reportPrimitiveCannotBeNull();
                return GeneratorBuildersFactory.longBuilder().minValue(0L).maxValue(0L).ruleRemark(RuleRemark.MIN_VALUE).build();
            }
            return builder.build((IConfigDto)config, true);
        };
    }

    BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> doubleGeneratorSupplier(boolean isPrimitive) {
        return (config, builder) -> {
            if (config.getRuleRemark() == RuleRemark.NULL_VALUE && isPrimitive) {
                this.reportPrimitiveCannotBeNull();
                return GeneratorBuildersFactory.doubleBuilder().minValue(0.0).maxValue(0.0).ruleRemark(RuleRemark.MIN_VALUE).build();
            }
            return builder.build((IConfigDto)config, true);
        };
    }

    private void prepareCustomRemarks(IGenerator<?> generator, String fieldName) {
        if (generator instanceof CustomGenerator) {
            IGenerator<?> usersGeneratorInstance = ((CustomGenerator)generator).getUsersGeneratorInstance();
            if (usersGeneratorInstance instanceof ICollectionGenerator) {
                this.prepareCustomRemarks(((ICollectionGenerator)usersGeneratorInstance).getElementGenerator(), fieldName);
            }
            if (usersGeneratorInstance instanceof ICustomGeneratorRemarkable) {
                ICustomGeneratorRemarkable remarkableGenerator = (ICustomGeneratorRemarkable)usersGeneratorInstance;
                this.typeGeneratorRemarksProvider.getRemarks(fieldName, remarkableGenerator).ifPresent(remarkableGenerator::setRuleRemarks);
            }
        }
    }

    private String getFieldName() {
        return this.field.getName();
    }

    private Class<?> getFieldType() {
        return this.field.getType();
    }

    private void reportPrimitiveCannotBeNull() {
        log.warn("Primitive field " + this.getFieldName() + " can't be null, it will be assigned to '0'");
    }

    @Override
    public void accept(TypeGeneratorsProvider.ProvidersVisitor visitor) {
        super.accept(visitor);
        this.generatorBuildersProviderByType.accept(visitor);
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setDtoInstance(Object dtoInstance) {
        this.dtoInstance = dtoInstance;
    }

    public void setRuleInfo(IRuleInfo ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    public void setNestedDtoGeneratorSupplier(Supplier<DtoGenerator<?>> nestedDtoGeneratorSupplier) {
        this.nestedDtoGeneratorSupplier = nestedDtoGeneratorSupplier;
    }
}

