/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.providers;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.config.TypeGeneratorBuildersDefaultConfig;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.typegenerators.providers.AbstractGeneratorBuildersProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorBuildersProviderByField
extends AbstractGeneratorBuildersProvider {
    private static final Logger log = LoggerFactory.getLogger(GeneratorBuildersProviderByField.class);
    private final Map<String, IGeneratorBuilder> overriddenBuildersForFields;
    private Field field;

    public GeneratorBuildersProviderByField(DtoGeneratorInstanceConfig configuration, Map<String, IGeneratorBuilder> overriddenBuildersForFields) {
        super(configuration);
        this.overriddenBuildersForFields = overriddenBuildersForFields;
    }

    @Override
    public Optional<IGenerator<?>> selectOrCreateGenerator() {
        IGenerator<?> generator = null;
        if (this.overriddenBuildersForFields.containsKey(this.getFieldName())) {
            IGeneratorBuilder genBuilder = this.overriddenBuildersForFields.get(this.getFieldName());
            if (genBuilder instanceof IGeneratorBuilderConfigurable) {
                IGeneratorBuilderConfigurable genBuilderConfigurable = (IGeneratorBuilderConfigurable)genBuilder;
                generator = this.getGenerator(() -> TypeGeneratorBuildersDefaultConfig.getInstance().getConfig(genBuilderConfigurable.getClass(), this.getFieldType()), () -> genBuilderConfigurable, (config, builder) -> {
                    if (config instanceof EnumGenerator.ConfigDto) {
                        ((EnumGenerator.ConfigDto)config).setEnumClass(this.getFieldType());
                    }
                    return builder.build((IConfigDto)config, true);
                }, this.getFieldType());
            } else {
                log.debug("GenBuilder explicitly set fo field builds as is.");
                generator = genBuilder.build();
            }
        }
        return Optional.ofNullable(generator);
    }

    private String getFieldName() {
        return this.field.getName();
    }

    private Class<?> getFieldType() {
        return this.field.getType();
    }

    public void setField(Field field) {
        this.field = field;
    }
}

