/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.providers;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.config.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.config.TypeGeneratorBuildersDefaultConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.EnumGenerator;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersHolder;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersHolderGeneral;
import org.laoruga.dtogenerator.typegenerators.providers.AbstractGeneratorBuildersProvider;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorBuildersProviderByType
extends AbstractGeneratorBuildersProvider {
    private static final Logger log = LoggerFactory.getLogger(GeneratorBuildersProviderByType.class);
    private final GeneratorBuildersHolder userGeneratorBuilders;
    private final GeneratorBuildersHolder generalGeneratorBuilders = GeneratorBuildersHolderGeneral.getInstance();
    private Field field;

    public GeneratorBuildersProviderByType(DtoGeneratorInstanceConfig configuration, GeneratorBuildersHolder userGeneratorBuilders) {
        super(configuration);
        this.userGeneratorBuilders = userGeneratorBuilders;
    }

    @Override
    public Optional<IGenerator<?>> selectOrCreateGenerator() {
        if (DtoGeneratorStaticConfig.getInstance().getGenerateAllKnownTypes().booleanValue()) {
            return this.selectOrCreateGenerator(this.getGeneratedType());
        }
        return Optional.empty();
    }

    Optional<IGenerator<?>> selectOrCreateGenerator(Class<?> generatedType) {
        Optional<IGeneratorBuilder> maybeBuilder = this.userGeneratorBuilders.getBuilder(generatedType);
        if (!maybeBuilder.isPresent()) {
            maybeBuilder = this.generalGeneratorBuilders.getBuilder(generatedType);
        }
        IGenerator<?> generator = null;
        if (maybeBuilder.isPresent()) {
            IGeneratorBuilder genBuilder = maybeBuilder.get();
            if (genBuilder instanceof IGeneratorBuilderConfigurable) {
                BiFunction<IConfigDto, IGeneratorBuilderConfigurable, IGenerator<?>> generatorSupplier;
                if (genBuilder instanceof EnumGenerator.EnumGeneratorBuilder) {
                    generatorSupplier = this.enumGeneratorSupplier(this.getGeneratedType());
                } else if (Collection.class.isAssignableFrom(generatedType)) {
                    Class<?> elementType = ReflectionUtils.getSingleGenericType(this.field);
                    Optional<IGenerator<?>> maybeElementGenerator = this.selectOrCreateGenerator(elementType);
                    generatorSupplier = this.collectionGeneratorSupplier(maybeElementGenerator.orElseThrow(() -> new DtoGeneratorException("Collection element generator not found, for type: '" + elementType + "'")));
                } else {
                    generatorSupplier = (config, builder) -> builder.build((IConfigDto)config, true);
                }
                generator = this.getGenerator(() -> TypeGeneratorBuildersDefaultConfig.getInstance().getConfig(genBuilder.getClass(), this.getGeneratedType()), () -> (IGeneratorBuilderConfigurable)genBuilder, generatorSupplier, this.getGeneratedType());
            } else {
                log.debug("Unknown generator builder found by field type, trying to build 'as is' without configuring.");
            }
        }
        return Optional.ofNullable(generator);
    }

    private Class<?> getGeneratedType() {
        return this.field.getType();
    }

    public void setField(Field field) {
        this.field = field;
    }
}

