/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.math3.util.Pair;
import org.laoruga.dtogenerator.DtoGenerator;
import org.laoruga.dtogenerator.DtoGeneratorBuildersTree;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.FieldGroupFilter;
import org.laoruga.dtogenerator.TypeGeneratorRemarksProvider;
import org.laoruga.dtogenerator.TypeGeneratorsProvider;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.remarks.CustomRuleRemarkWrapper;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public class DtoGeneratorBuilder<T> {
    private final DtoGeneratorInstanceConfig configuration;
    private final TypeGeneratorsProvider<T> typeGeneratorsProvider;
    private final DtoGeneratorBuildersTree dtoGeneratorBuildersTree;
    private final FieldGroupFilter fieldGroupFilter;

    DtoGeneratorBuilder(Class<T> dtoClass) {
        this(new DtoInstanceSupplier<T>(dtoClass));
    }

    DtoGeneratorBuilder(T dtoInstance) {
        this(() -> dtoInstance);
    }

    private DtoGeneratorBuilder(Supplier<T> dtoInstanceSupplier) {
        this.configuration = new DtoGeneratorInstanceConfig();
        this.fieldGroupFilter = new FieldGroupFilter(new String[0]);
        this.dtoGeneratorBuildersTree = new DtoGeneratorBuildersTree(this);
        this.typeGeneratorsProvider = new TypeGeneratorsProvider(this.configuration, new TypeGeneratorRemarksProvider(), this.fieldGroupFilter, new String[]{"%ROOT%"}, this.dtoGeneratorBuildersTree);
        this.typeGeneratorsProvider.setDtoInstanceSupplier(dtoInstanceSupplier);
    }

    DtoGeneratorBuilder(DtoGeneratorBuilder<T> toCopy, String[] pathFromRootDto) {
        this.configuration = toCopy.configuration;
        this.typeGeneratorsProvider = new TypeGeneratorsProvider(toCopy.typeGeneratorsProvider, pathFromRootDto);
        this.dtoGeneratorBuildersTree = toCopy.dtoGeneratorBuildersTree;
        this.fieldGroupFilter = toCopy.fieldGroupFilter;
    }

    public DtoGeneratorBuilder<T> setGeneratorBuilder(@NonNull Class<? extends Annotation> rulesAnnotationClass, @NonNull IGeneratorBuilder generatorBuilder) throws DtoGeneratorException {
        if (rulesAnnotationClass == null) {
            throw new NullPointerException("rulesAnnotationClass is marked non-null but is null");
        }
        if (generatorBuilder == null) {
            throw new NullPointerException("generatorBuilder is marked non-null but is null");
        }
        this.typeGeneratorsProvider.overrideGenerator(rulesAnnotationClass, generatorBuilder);
        return this;
    }

    public DtoGeneratorBuilder<T> setGeneratorBuilder(@NonNull String fieldName, @NonNull IGeneratorBuilder generatorBuilder) throws DtoGeneratorException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (generatorBuilder == null) {
            throw new NullPointerException("generatorBuilder is marked non-null but is null");
        }
        Pair<String, String[]> fieldAndPath = this.splitPathToField(fieldName);
        DtoGeneratorBuilder<?> dtoGeneratorBuilder = this.getBuilderFromTreeOrThis((String[])fieldAndPath.getSecond());
        dtoGeneratorBuilder.typeGeneratorsProvider.setGeneratorBuilderForField((String)fieldAndPath.getFirst(), generatorBuilder);
        return this;
    }

    public DtoGeneratorBuilder<T> setRuleRemark(@NonNull String fieldName, @NonNull RuleRemark ruleRemark) throws DtoGeneratorException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (ruleRemark == null) {
            throw new NullPointerException("ruleRemark is marked non-null but is null");
        }
        Pair<String, String[]> fieldAndPath = this.splitPathToField(fieldName);
        DtoGeneratorBuilder<?> fieldAndBuilder = this.getBuilderFromTreeOrThis((String[])fieldAndPath.getSecond());
        fieldAndBuilder.typeGeneratorsProvider.getTypeGeneratorRemarksProvider().setBasicRuleRemarkForField((String)fieldAndPath.getFirst(), ruleRemark);
        return this;
    }

    public DtoGeneratorBuilder<T> setRuleRemark(@NonNull RuleRemark basicRuleRemark) throws DtoGeneratorException {
        if (basicRuleRemark == null) {
            throw new NullPointerException("basicRuleRemark is marked non-null but is null");
        }
        this.typeGeneratorsProvider.getTypeGeneratorRemarksProvider().setBasicRuleRemarkForFields(basicRuleRemark);
        return this;
    }

    public DtoGeneratorBuilder<T> setRuleRemarksCustom(@NonNull String fieldName, CustomRuleRemarkWrapper ... ruleRemark) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (ruleRemark == null) {
            throw new NullPointerException("ruleRemark is marked non-null but is null");
        }
        Pair<String, String[]> fieldAndPath = this.splitPathToField(fieldName);
        DtoGeneratorBuilder<?> fieldAndBuilder = this.getBuilderFromTreeOrThis((String[])fieldAndPath.getSecond());
        fieldAndBuilder.typeGeneratorsProvider.getTypeGeneratorRemarksProvider().addCustomRuleRemarkForField((String)fieldAndPath.getFirst(), ruleRemark);
        return this;
    }

    public DtoGeneratorBuilder<T> setRuleRemarksCustom(CustomRuleRemarkWrapper ... ruleRemarks) {
        if (ruleRemarks == null) {
            throw new NullPointerException("ruleRemarks is marked non-null but is null");
        }
        this.typeGeneratorsProvider.getTypeGeneratorRemarksProvider().addRuleRemarkForAllFields(ruleRemarks);
        return this;
    }

    public DtoGeneratorBuilder<T> includeGroups(String ... groups) {
        if (groups != null && groups.length != 0) {
            this.typeGeneratorsProvider.getRulesInfoExtractor().getFieldsGroupFilter().includeGroups(groups);
        }
        return this;
    }

    public DtoGeneratorInstanceConfig getUserConfig() {
        return this.configuration;
    }

    public DtoGenerator<T> build() {
        return new DtoGenerator<T>(this.typeGeneratorsProvider, this);
    }

    private DtoGeneratorBuilder<?> getBuilderFromTreeOrThis(String[] pathToField) {
        if (pathToField != null) {
            return this.dtoGeneratorBuildersTree.getBuilder(pathToField);
        }
        return this;
    }

    private Pair<String, String[]> splitPathToField(String fieldsFromRoot) {
        if (fieldsFromRoot.contains(".")) {
            String[] pathToField = fieldsFromRoot.split("\\.");
            String fieldName = pathToField[pathToField.length - 1];
            pathToField = Arrays.copyOf(pathToField, pathToField.length - 1);
            return Pair.create((Object)fieldName, (Object)pathToField);
        }
        return Pair.create((Object)fieldsFromRoot, null);
    }

    protected TypeGeneratorsProvider<T> getTypeGeneratorsProvider() {
        return this.typeGeneratorsProvider;
    }
}

