/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.NonNull;
import org.laoruga.dtogenerator.DtoGeneratorBuilder;
import org.laoruga.dtogenerator.DtoGeneratorBuildersTree;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.FieldGroupFilter;
import org.laoruga.dtogenerator.TypeGeneratorRemarksProvider;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.config.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.rules.IRuleInfo;
import org.laoruga.dtogenerator.rules.RulesInfoExtractor;
import org.laoruga.dtogenerator.rules.RulesInfoHelper;
import org.laoruga.dtogenerator.typegenerators.builders.GeneratorBuildersHolder;
import org.laoruga.dtogenerator.typegenerators.providers.AbstractGeneratorBuildersProvider;
import org.laoruga.dtogenerator.typegenerators.providers.GeneratorBuildersProviderByAnnotation;
import org.laoruga.dtogenerator.typegenerators.providers.GeneratorBuildersProviderByField;
import org.laoruga.dtogenerator.typegenerators.providers.GeneratorBuildersProviderByType;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeGeneratorsProvider<T> {
    private static final Logger log = LoggerFactory.getLogger(TypeGeneratorsProvider.class);
    private final DtoGeneratorInstanceConfig configuration;
    private Supplier<T> dtoInstanceSupplier;
    private final String[] pathFromRootDto;
    private final DtoGeneratorBuildersTree dtoGeneratorBuildersTree;
    private final TypeGeneratorRemarksProvider typeGeneratorRemarksProvider;
    private final Map<Class<? extends Annotation>, IGeneratorBuilder> overriddenBuilders;
    private final Map<String, IGeneratorBuilder> overriddenBuildersForFields;
    private final GeneratorBuildersHolder userGenBuildersMapping;
    private final AbstractGeneratorBuildersProvider builderSelectChainByAnnotation;
    private final AbstractGeneratorBuildersProvider builderSelectChainByType;
    private final RulesInfoExtractor rulesInfoExtractor;

    TypeGeneratorsProvider(DtoGeneratorInstanceConfig configuration, TypeGeneratorRemarksProvider typeGeneratorRemarksProvider, FieldGroupFilter fieldGroupFilter, String[] pathFromRootDto, DtoGeneratorBuildersTree dtoGeneratorBuildersTree) {
        this.configuration = configuration;
        this.overriddenBuildersForFields = new HashMap<String, IGeneratorBuilder>();
        this.userGenBuildersMapping = new GeneratorBuildersHolder(new ArrayList<GeneratorBuildersHolder.GenBuilderInfo>());
        this.typeGeneratorRemarksProvider = typeGeneratorRemarksProvider;
        this.pathFromRootDto = pathFromRootDto;
        this.overriddenBuilders = new ConcurrentHashMap<Class<? extends Annotation>, IGeneratorBuilder>();
        this.rulesInfoExtractor = new RulesInfoExtractor(fieldGroupFilter);
        this.dtoGeneratorBuildersTree = dtoGeneratorBuildersTree;
        this.builderSelectChainByType = this.initAllKnownTypesChain(this.overriddenBuildersForFields);
        this.builderSelectChainByAnnotation = this.initAnnotationChain(this.overriddenBuildersForFields);
    }

    TypeGeneratorsProvider(TypeGeneratorsProvider<?> copyFrom, String[] pathFromRootDto) {
        this.configuration = copyFrom.configuration;
        this.overriddenBuildersForFields = new HashMap<String, IGeneratorBuilder>();
        this.userGenBuildersMapping = copyFrom.getUserGenBuildersMapping();
        this.typeGeneratorRemarksProvider = copyFrom.getTypeGeneratorRemarksProvider().copy();
        this.pathFromRootDto = pathFromRootDto;
        this.overriddenBuilders = copyFrom.getOverriddenBuilders();
        this.rulesInfoExtractor = copyFrom.getRulesInfoExtractor();
        this.dtoGeneratorBuildersTree = copyFrom.getDtoGeneratorBuildersTree();
        this.builderSelectChainByType = super.initAllKnownTypesChain(this.overriddenBuildersForFields);
        this.builderSelectChainByAnnotation = super.initAnnotationChain(this.overriddenBuildersForFields);
    }

    void setDtoInstanceSupplier(Supplier<?> dtoInstance) {
        try {
            this.dtoInstanceSupplier = dtoInstance;
        }
        catch (ClassCastException e) {
            throw new DtoGeneratorException("Unexpected error", e);
        }
    }

    private AbstractGeneratorBuildersProvider initAllKnownTypesChain(Map<String, IGeneratorBuilder> buildersMapping) {
        GeneratorBuildersProviderByField byField = new GeneratorBuildersProviderByField(this.configuration, buildersMapping);
        GeneratorBuildersProviderByType byType = new GeneratorBuildersProviderByType(this.configuration, this.userGenBuildersMapping);
        byField.addNextProvider(byType);
        return byField;
    }

    private AbstractGeneratorBuildersProvider initAnnotationChain(Map<String, IGeneratorBuilder> buildersMapping) {
        GeneratorBuildersProviderByField byField = new GeneratorBuildersProviderByField(this.configuration, buildersMapping);
        GeneratorBuildersProviderByAnnotation byAnnotation = new GeneratorBuildersProviderByAnnotation(this.configuration, new GeneratorBuildersProviderByType(this.configuration, this.userGenBuildersMapping), this.typeGeneratorRemarksProvider, this.userGenBuildersMapping);
        byField.addNextProvider(byAnnotation);
        return byField;
    }

    Optional<IGenerator<?>> getGenerator(Field field) {
        Optional<IRuleInfo> maybeRulesInfo = this.getRuleInfo(field);
        if (maybeRulesInfo.isPresent()) {
            this.getBuilderSelectChainByAnnotation().accept(new ProvidersVisitor(field, maybeRulesInfo.get()));
            return this.getBuilderSelectChainByAnnotation().getGenerator();
        }
        this.getBuilderSelectChainByType().accept(new ProvidersVisitor(field, null));
        return this.getBuilderSelectChainByType().getGenerator();
    }

    private Optional<IRuleInfo> getRuleInfo(Field field) {
        try {
            AnnotatingErrorsHandler.ResultDto validationResult = new AnnotatingErrorsHandler(field.getDeclaredAnnotations(), this.configuration).validate();
            if (!validationResult.getResultString().isEmpty()) {
                throw new DtoGeneratorException("Field annotated wrong:\n" + validationResult.getResultString());
            }
            return this.rulesInfoExtractor.checkAndWrapAnnotations(field);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while extracting rule annotations from field: '" + field + "'", e);
        }
    }

    void setGeneratorBuilderForField(String fieldName, IGeneratorBuilder genBuilder) throws DtoGeneratorException {
        if (this.overriddenBuildersForFields.containsKey(fieldName)) {
            throw new DtoGeneratorException("Generator has already been explicitly added for field: '" + fieldName + "'");
        }
        this.overriddenBuildersForFields.put(fieldName, genBuilder);
    }

    void overrideGenerator(Class<? extends Annotation> rulesClass, @NonNull IGeneratorBuilder genBuilder) {
        if (genBuilder == null) {
            throw new NullPointerException("genBuilder is marked non-null but is null");
        }
        try {
            Class generatedType = ReflectionUtils.getDefaultMethodValue(rulesClass, "generatedType", Class.class);
            this.getUserGenBuildersMapping().addBuilder(rulesClass, generatedType, genBuilder);
        }
        catch (NoSuchMethodException e) {
            throw new DtoGeneratorException("Rules annotation '" + rulesClass.getName() + "' does not contain 'generatedType' method with return type 'Class'", e);
        }
    }

    DtoGeneratorInstanceConfig getConfiguration() {
        return this.configuration;
    }

    Supplier<T> getDtoInstanceSupplier() {
        return this.dtoInstanceSupplier;
    }

    String[] getPathFromRootDto() {
        return this.pathFromRootDto;
    }

    DtoGeneratorBuildersTree getDtoGeneratorBuildersTree() {
        return this.dtoGeneratorBuildersTree;
    }

    TypeGeneratorRemarksProvider getTypeGeneratorRemarksProvider() {
        return this.typeGeneratorRemarksProvider;
    }

    Map<Class<? extends Annotation>, IGeneratorBuilder> getOverriddenBuilders() {
        return this.overriddenBuilders;
    }

    Map<String, IGeneratorBuilder> getOverriddenBuildersForFields() {
        return this.overriddenBuildersForFields;
    }

    GeneratorBuildersHolder getUserGenBuildersMapping() {
        return this.userGenBuildersMapping;
    }

    AbstractGeneratorBuildersProvider getBuilderSelectChainByAnnotation() {
        return this.builderSelectChainByAnnotation;
    }

    AbstractGeneratorBuildersProvider getBuilderSelectChainByType() {
        return this.builderSelectChainByType;
    }

    public RulesInfoExtractor getRulesInfoExtractor() {
        return this.rulesInfoExtractor;
    }

    static class AnnotatingErrorsHandler {
        private final Annotation[] annotations;
        private final ResultDto resultDto = new ResultDto();
        private final DtoGeneratorInstanceConfig configuration;

        void count() {
            for (Annotation annotation : this.annotations) {
                if (RulesInfoHelper.isItRule(annotation)) {
                    this.resultDto.generalRule++;
                }
                if (RulesInfoHelper.isItMultipleRules(annotation)) {
                    this.resultDto.groupOfGeneralRules++;
                }
                if (RulesInfoHelper.isItCollectionRule(annotation)) {
                    this.resultDto.collectionRule++;
                }
                if (!RulesInfoHelper.isItCollectionRules(annotation)) continue;
                this.resultDto.groupOfCollectionRules++;
            }
        }

        public ResultDto validate() {
            this.count();
            int idx = 0;
            if (this.resultDto.generalRule > 1) {
                this.resultDto.resultString.append(++idx).append(". Found '").append(this.resultDto.generalRule).append("' @Rule annotations for various types, ").append("expected 1 or 0.").append("\n");
            }
            if (this.resultDto.groupOfGeneralRules > 1) {
                this.resultDto.resultString.append(++idx).append(". Found '").append(this.resultDto.groupOfGeneralRules).append("' @Rules annotations for various types, expected @Rules for single type only.").append("\n");
            }
            if (this.resultDto.collectionRule > 1) {
                this.resultDto.resultString.append(++idx).append(". Found '").append(this.resultDto.collectionRule).append("' @CollectionRule annotations for various collection types, expected 1 or 0.").append("\n");
            }
            if (this.resultDto.groupOfCollectionRules > 1) {
                this.resultDto.resultString.append(++idx).append(". Found '").append(this.resultDto.groupOfCollectionRules).append("' @CollectionRules annotations for various collection types, ").append("expected @CollectionRules for single collection type only.").append("\n");
            }
            if (!this.configuration.getGenerateAllKnownTypes().booleanValue() && this.resultDto.getSumOfCollectionRules() > 0 && this.resultDto.getSumOfCollectionRules() != this.resultDto.getSumOfGeneralRules()) {
                this.resultDto.resultString.append(++idx).append(". Missed @Rule annotation for item of collection.").append("\n");
            }
            return this.resultDto;
        }

        public AnnotatingErrorsHandler(Annotation[] annotations, DtoGeneratorInstanceConfig configuration) {
            this.annotations = annotations;
            this.configuration = configuration;
        }

        static class ResultDto {
            private final StringBuilder resultString = new StringBuilder();
            private int generalRule = 0;
            private int groupOfGeneralRules = 0;
            private int collectionRule = 0;
            private int groupOfCollectionRules = 0;

            public String getResultString() {
                return this.resultString.toString();
            }

            int getSumOfCollectionRules() {
                return this.collectionRule + this.groupOfCollectionRules;
            }

            int getSumOfGeneralRules() {
                return this.generalRule + this.groupOfGeneralRules;
            }

            public int getGeneralRule() {
                return this.generalRule;
            }

            public int getGroupOfGeneralRules() {
                return this.groupOfGeneralRules;
            }

            public int getCollectionRule() {
                return this.collectionRule;
            }

            public int getGroupOfCollectionRules() {
                return this.groupOfCollectionRules;
            }

            public ResultDto(int generalRule, int groupOfGeneralRules, int collectionRule, int groupOfCollectionRules) {
                this.generalRule = generalRule;
                this.groupOfGeneralRules = groupOfGeneralRules;
                this.collectionRule = collectionRule;
                this.groupOfCollectionRules = groupOfCollectionRules;
            }

            public ResultDto() {
            }
        }
    }

    public class ProvidersVisitor {
        final Field field;
        final IRuleInfo ruleInfo;

        public void visit(AbstractGeneratorBuildersProvider abstractProvider) {
            if (abstractProvider.getClass() == GeneratorBuildersProviderByType.class) {
                this.visitByType((GeneratorBuildersProviderByType)abstractProvider);
            } else if (abstractProvider.getClass() == GeneratorBuildersProviderByField.class) {
                this.visitByField((GeneratorBuildersProviderByField)abstractProvider);
            } else if (abstractProvider.getClass() == GeneratorBuildersProviderByAnnotation.class) {
                this.visitByAnnotation((GeneratorBuildersProviderByAnnotation)abstractProvider);
            } else {
                throw new DtoGeneratorException("Visitor no defined");
            }
        }

        void visitByType(GeneratorBuildersProviderByType byType) {
            byType.setField(this.field);
        }

        void visitByField(GeneratorBuildersProviderByField byField) {
            byField.setField(this.field);
        }

        void visitByAnnotation(GeneratorBuildersProviderByAnnotation byAnnotation) {
            byAnnotation.setField(this.field);
            byAnnotation.setMaybeRemark(TypeGeneratorsProvider.this.typeGeneratorRemarksProvider.isBasicRuleRemarkExists(this.field.getName()) ? TypeGeneratorsProvider.this.typeGeneratorRemarksProvider.getBasicRuleRemark(this.field.getName()) : null);
            byAnnotation.setDtoInstanceSupplier(TypeGeneratorsProvider.this.dtoInstanceSupplier);
            byAnnotation.setRuleInfo(this.ruleInfo);
            byAnnotation.setNestedDtoGeneratorSupplier(() -> {
                String[] pathToNestedDtoField = Arrays.copyOf(TypeGeneratorsProvider.this.pathFromRootDto, TypeGeneratorsProvider.this.pathFromRootDto.length + 1);
                pathToNestedDtoField[((TypeGeneratorsProvider)TypeGeneratorsProvider.this).pathFromRootDto.length] = this.field.getName();
                DtoGeneratorBuilder<?> nestedDtoGeneratorBuilder = TypeGeneratorsProvider.this.dtoGeneratorBuildersTree.getBuilder(pathToNestedDtoField);
                nestedDtoGeneratorBuilder.getTypeGeneratorsProvider().setDtoInstanceSupplier(new DtoInstanceSupplier(this.field.getType()));
                return nestedDtoGeneratorBuilder.build();
            });
        }

        public ProvidersVisitor(Field field, IRuleInfo ruleInfo) {
            this.field = field;
            this.ruleInfo = ruleInfo;
        }
    }
}

