/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.laoruga.dtogenerator.config.DtoGeneratorConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoGeneratorFileConfig
extends DtoGeneratorConfig {
    private static final Logger log = LoggerFactory.getLogger(DtoGeneratorFileConfig.class);
    Properties properties;

    public DtoGeneratorFileConfig(String propsFile) {
        this.properties = this.loadProperties(propsFile);
        this.initPropsDto();
    }

    protected Properties loadProperties(String propsFile) {
        Optional<Properties> defaultProps = DtoGeneratorFileConfig.loadProperties(DtoGeneratorFileConfig.class.getClassLoader(), "default-" + propsFile);
        Optional<Properties> customProps = DtoGeneratorFileConfig.loadProperties(Thread.currentThread().getContextClassLoader(), propsFile);
        Properties props = defaultProps.orElseGet(Properties::new);
        customProps.ifPresent(props::putAll);
        return props;
    }

    private void initPropsDto() {
        this.setMaxDependentGenerationCycles(Integer.parseInt(this.getProperty("maxDependentGenerationCycles", "100")));
        this.setMaxCollectionGenerationCycles(Integer.parseInt(this.getProperty("maxCollectionGenerationCycles", "100")));
        this.setGenerateAllKnownTypes(Boolean.parseBoolean(this.getProperty("generateAllKnownTypes", "false")));
    }

    private String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Properties> loadProperties(ClassLoader classLoader, String fileName) {
        Properties properties = new Properties();
        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            return Optional.empty();
        }
        try (InputStream propertiesStream = classLoader.getResourceAsStream(fileName);){
            log.debug("Reading properties from {}", (Object)resource);
            properties.load(propertiesStream);
            Optional<Properties> optional = Optional.of(properties);
            return optional;
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Failed to read properties file '" + fileName + "' from classpath", e);
        }
    }
}

