/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rules;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.rules.IRuleInfo;
import org.laoruga.dtogenerator.rules.IRuleInfoBuilder;
import org.laoruga.dtogenerator.rules.RuleInfo;
import org.laoruga.dtogenerator.rules.RuleInfoCollection;

class RuleInfoBuilder
implements IRuleInfoBuilder {
    private Annotation rule;
    private RuleType ruleType;
    private Boolean multipleRules;
    private String groupName;
    private RuleInfoBuilder collectionBuilder;

    public boolean isEmpty() {
        return this.rule == null && this.collectionBuilder == null;
    }

    public RuleInfoBuilder rule(Annotation rule) {
        if (this.rule != null) {
            RuleInfoBuilder.throwUnitException();
        }
        this.rule = rule;
        return this;
    }

    public RuleInfoBuilder collectionRuleInfoBuilder(RuleInfoBuilder collectionBuilder) {
        if (this.collectionBuilder != null) {
            RuleInfoBuilder.throwCollectionException();
        }
        this.collectionBuilder = collectionBuilder;
        return this;
    }

    public RuleInfoBuilder ruleType(RuleType ruleType) {
        if (this.ruleType != null) {
            RuleInfoBuilder.throwUnitException();
        }
        this.ruleType = ruleType;
        return this;
    }

    public RuleInfoBuilder multipleRules(boolean multipleRules) {
        if (this.multipleRules != null) {
            RuleInfoBuilder.throwUnitException();
        }
        this.multipleRules = multipleRules;
        return this;
    }

    public RuleInfoBuilder groupName(String groupName) {
        if (this.groupName != null) {
            RuleInfoBuilder.throwUnitException();
        }
        this.groupName = groupName;
        return this;
    }

    @Override
    public IRuleInfo build() {
        if (this.collectionBuilder == null) {
            return this.buildUnit();
        }
        return this.buildCollection();
    }

    private IRuleInfo buildCollection() {
        this.asserCollectionParams();
        this.checkCollectionGroup();
        RuleInfoCollection ruleInfo = new RuleInfoCollection();
        ruleInfo.setElementRule(this.rule != null ? this.buildUnit() : null);
        ruleInfo.setCollectionRule(this.collectionBuilder.buildUnit());
        ruleInfo.setGroup(this.groupName);
        return ruleInfo;
    }

    private IRuleInfo buildUnit() {
        this.assertUnitParams();
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setRule(this.rule);
        ruleInfo.setRuleType(this.ruleType);
        ruleInfo.setGroup(this.groupName);
        ruleInfo.setMultipleRules(this.multipleRules);
        return ruleInfo;
    }

    private void assertUnitParams() {
        try {
            Objects.requireNonNull(this.rule);
            Objects.requireNonNull(this.ruleType);
            Objects.requireNonNull(this.groupName);
            Objects.requireNonNull(this.multipleRules);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Failed to construct unit or collection rules info.", e);
        }
    }

    private void asserCollectionParams() {
        try {
            this.collectionBuilder.assertUnitParams();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Failed to construct collection item rules info.", e);
        }
        try {
            this.assertUnitParams();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Failed to construct collection rules info.", e);
        }
    }

    private void checkCollectionGroup() {
        if (!this.groupName.equals(this.collectionBuilder.getGroupName())) {
            throw new DtoGeneratorException("Unexpected error, collection generator's group not equals to unit");
        }
    }

    private static void throwUnitException() {
        throw new DtoGeneratorException("Field annotated more then one unit rules annotation");
    }

    private static void throwCollectionException() {
        throw new DtoGeneratorException("Field annotated more then one collection rules annotation");
    }

    Annotation getRule() {
        return this.rule;
    }

    RuleType getRuleType() {
        return this.ruleType;
    }

    Boolean getMultipleRules() {
        return this.multipleRules;
    }

    String getGroupName() {
        return this.groupName;
    }

    RuleInfoBuilder getCollectionBuilder() {
        return this.collectionBuilder;
    }
}

