/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.rules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.commons.math3.util.Pair;
import org.laoruga.dtogenerator.FieldGroupFilter;
import org.laoruga.dtogenerator.constants.RuleType;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.rules.IRuleInfo;
import org.laoruga.dtogenerator.rules.RuleInfo;
import org.laoruga.dtogenerator.rules.RuleInfoBuilder;
import org.laoruga.dtogenerator.rules.RulesInfoHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesInfoExtractor {
    private static final Logger log = LoggerFactory.getLogger(RulesInfoExtractor.class);
    private final FieldGroupFilter fieldsGroupFilter;
    private static final String ERROR_MSG_PATTERN = "Inappropriate generation rule annotation: '%s' for field: '%s'";

    public Optional<IRuleInfo> checkAndWrapAnnotations(Field field) {
        RuleInfoBuilder ruleInfoBuilder = new RuleInfoBuilder();
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (RulesInfoHelper.isItRule(annotation)) {
                this.extractRuleInfo(ruleInfoBuilder, annotation);
                continue;
            }
            if (RulesInfoHelper.isItMultipleRules(annotation)) {
                this.extractRuleInfoFromMultipleRules(ruleInfoBuilder, annotation);
                continue;
            }
            if (RulesInfoHelper.isItCollectionRule(annotation)) {
                this.extractCollectionRuleInfo(ruleInfoBuilder, annotation);
                continue;
            }
            if (!RulesInfoHelper.isItCollectionRules(annotation)) continue;
            this.extractCollectionRuleInfoFromMultipleRules(ruleInfoBuilder, annotation);
        }
        if (ruleInfoBuilder.isEmpty()) {
            return Optional.empty();
        }
        IRuleInfo ruleInfo = ruleInfoBuilder.build();
        if (this.skipByGroup(ruleInfo)) {
            return Optional.empty();
        }
        return Optional.of(ruleInfo);
    }

    private void extractRuleInfo(RuleInfoBuilder ruleInfoBuilder, Annotation rule) {
        ruleInfoBuilder.rule(rule).ruleType(RuleType.getType(rule)).multipleRules(false).groupName(RulesInfoExtractor.getGroupNameFromRuleAnnotation(rule));
    }

    private void extractRuleInfoFromMultipleRules(RuleInfoBuilder ruleInfoBuilder, Annotation rule) {
        Optional<Pair<String, Annotation>> groupAndRule = this.selectRuleByGroup(rule);
        if (groupAndRule.isPresent()) {
            Annotation ruleSelectedByGroup = (Annotation)groupAndRule.get().getSecond();
            ruleInfoBuilder.rule(ruleSelectedByGroup).ruleType(RuleType.getType(ruleSelectedByGroup)).groupName((String)groupAndRule.get().getFirst()).multipleRules(true);
        }
    }

    private void extractCollectionRuleInfo(RuleInfoBuilder ruleInfoBuilder, Annotation rule) {
        RuleInfoBuilder collectionRuleInfo = RuleInfo.builder();
        ruleInfoBuilder.collectionRuleInfoBuilder(collectionRuleInfo.rule(rule).ruleType(RuleType.getType(rule)).multipleRules(false).groupName(RulesInfoExtractor.getGroupNameFromRuleAnnotation(rule)));
    }

    private void extractCollectionRuleInfoFromMultipleRules(RuleInfoBuilder ruleInfoBuilder, Annotation rule) {
        Optional<Pair<String, Annotation>> groupAndRule = this.selectRuleByGroup(rule);
        if (groupAndRule.isPresent()) {
            RuleInfoBuilder collectionRuleInfo = RuleInfo.builder();
            ruleInfoBuilder.collectionRuleInfoBuilder(collectionRuleInfo.rule((Annotation)groupAndRule.get().getSecond()).ruleType(RuleType.getType((Annotation)groupAndRule.get().getSecond())).groupName((String)groupAndRule.get().getFirst()).multipleRules(true));
        }
    }

    private boolean skipByGroup(IRuleInfo ruleInfo) {
        return !this.getFieldsGroupFilter().isContainsIncludeGroup(ruleInfo.getGroup());
    }

    private Optional<Pair<String, Annotation>> selectRuleByGroup(Annotation rules) {
        try {
            LinkedList<Annotation> uniqueGroups = new LinkedList<Annotation>();
            Object ruleAnnotationsArray = rules.getClass().getMethod("value", new Class[0]).invoke((Object)rules, new Object[0]);
            int length = Array.getLength(ruleAnnotationsArray);
            Optional<Pair<String, Annotation>> matched = Optional.empty();
            for (int i = 0; i < length; ++i) {
                Annotation rule = (Annotation)Array.get(ruleAnnotationsArray, i);
                String checkedGroup = RulesInfoExtractor.getGroupNameFromRuleAnnotation(rule);
                if (uniqueGroups.contains(rule)) {
                    throw new DtoGeneratorException("Rule group '" + checkedGroup + "' is repeating for field.");
                }
                uniqueGroups.add(rule);
                if (!this.getFieldsGroupFilter().isContainsIncludeGroup(checkedGroup)) continue;
                if (!matched.isPresent()) {
                    matched = Optional.of(Pair.create((Object)checkedGroup, (Object)rule));
                    continue;
                }
                throw new DtoGeneratorException("Ambiguous grouping of the field. Check groups of generators and include filters.");
            }
            return matched;
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DtoGeneratorException("Unexpected exception. Can't get 'group' from rules annotation", e);
        }
    }

    private static String getGroupNameFromRuleAnnotation(Annotation rule) {
        try {
            return (String)rule.annotationType().getMethod("group", new Class[0]).invoke((Object)rule, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DtoGeneratorException("Unexpected exception. Can't get 'group' from rules annotation", e);
        }
    }

    public FieldGroupFilter getFieldsGroupFilter() {
        return this.fieldsGroupFilter;
    }

    public RulesInfoExtractor(FieldGroupFilter fieldsGroupFilter) {
        this.fieldsGroupFilter = fieldsGroupFilter;
    }
}

