/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.laoruga.dtogenerator.api.generators.ICollectionGenerator;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.ListRule;
import org.laoruga.dtogenerator.api.rules.SetRule;
import org.laoruga.dtogenerator.config.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.ReflectionUtils;

public class CollectionGenerator
implements ICollectionGenerator<Object> {
    private final int minSize;
    private final int maxSize;
    private final Collection<Object> collectionInstance;
    private final IGenerator<Object> elementGenerator;
    private final IRuleRemark ruleRemark;

    public static CollectionGeneratorBuilder<?> builder() {
        return new CollectionGeneratorBuilder();
    }

    @Override
    public Collection<Object> generate() {
        int size;
        int maxAttempts = DtoGeneratorStaticConfig.getInstance().getMaxCollectionGenerationCycles();
        switch ((RuleRemark)this.ruleRemark) {
            case MIN_VALUE: {
                size = this.minSize;
                break;
            }
            case MAX_VALUE: {
                size = this.maxSize;
                break;
            }
            case RANDOM_VALUE: {
                size = new RandomDataGenerator().nextInt(this.minSize, this.maxSize);
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.ruleRemark);
            }
        }
        int ineffectiveAttempts = 0;
        while (this.collectionInstance.size() < size) {
            int prevSize = this.collectionInstance.size();
            this.collectionInstance.add(this.elementGenerator.generate());
            if (prevSize != this.collectionInstance.size() || ++ineffectiveAttempts != maxAttempts) continue;
            throw new DtoGeneratorException("Expected size: '" + size + "' of collection: '" + this.collectionInstance.getClass() + "' can't be reached. After '" + ineffectiveAttempts + "' attempts collection size is: '" + this.collectionInstance.size() + "'");
        }
        return this.collectionInstance;
    }

    @Override
    public IGenerator<Object> getElementGenerator() {
        return this.elementGenerator;
    }

    public CollectionGenerator(int minSize, int maxSize, Collection<Object> collectionInstance, IGenerator<Object> elementGenerator, IRuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.collectionInstance = collectionInstance;
        this.elementGenerator = elementGenerator;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Integer minSize;
        private Integer maxSize;
        private Supplier<Collection<?>> collectionInstance;
        private IGenerator<Object> elementGenerator;
        private IRuleRemark ruleRemark;

        public ConfigDto() {
        }

        public ConfigDto(SetRule rule) {
            this.minSize = rule.minSize();
            this.maxSize = rule.maxSize();
            this.collectionInstance = () -> ReflectionUtils.createCollectionInstance(rule.setClass());
            this.ruleRemark = rule.ruleRemark();
        }

        public ConfigDto(ListRule rule) {
            this.minSize = rule.minSize();
            this.maxSize = rule.maxSize();
            this.collectionInstance = () -> ReflectionUtils.createCollectionInstance(rule.listClass());
            this.ruleRemark = rule.ruleRemark();
        }

        public ConfigDto setCollectionInstance(Supplier<Collection<?>> collectionInstance) {
            this.collectionInstance = collectionInstance;
            return this;
        }

        public ConfigDto setElementGenerator(IGenerator<Object> elementGenerator) {
            this.elementGenerator = elementGenerator;
            return this;
        }

        public void merge(ConfigDto from) {
            if (from.getMinSize() != null) {
                this.minSize = from.getMinSize();
            }
            if (from.getMaxSize() != null) {
                this.maxSize = from.getMaxSize();
            }
            if (from.getCollectionInstance() != null) {
                this.collectionInstance = from.getCollectionInstance();
            }
            if (from.getElementGenerator() != null) {
                this.elementGenerator = from.getElementGenerator();
            }
            if (from.getRuleRemark() != null) {
                this.ruleRemark = from.getRuleRemark();
            }
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return CollectionGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto fromConfig = (ConfigDto)from;
            if (fromConfig.getMinSize() != null) {
                this.minSize = fromConfig.getMinSize();
            }
            if (fromConfig.getMaxSize() != null) {
                this.maxSize = fromConfig.getMaxSize();
            }
            if (fromConfig.getCollectionInstance() != null) {
                this.collectionInstance = fromConfig.getCollectionInstance();
            }
            if (fromConfig.getElementGenerator() != null) {
                this.elementGenerator = fromConfig.getElementGenerator();
            }
            if (fromConfig.getRuleRemark() != null) {
                this.ruleRemark = fromConfig.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public Integer getMinSize() {
            return this.minSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public Supplier<Collection<?>> getCollectionInstance() {
            return this.collectionInstance;
        }

        public IGenerator<Object> getElementGenerator() {
            return this.elementGenerator;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public ConfigDto(Integer minSize, Integer maxSize, Supplier<Collection<?>> collectionInstance, IGenerator<Object> elementGenerator, IRuleRemark ruleRemark) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.collectionInstance = collectionInstance;
            this.elementGenerator = elementGenerator;
            this.ruleRemark = ruleRemark;
        }

        public static class ConfigDtoBuilder {
            private Integer minSize;
            private Integer maxSize;
            private Supplier<Collection<?>> collectionInstance;
            private IGenerator<Object> elementGenerator;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder minSize(Integer minSize) {
                this.minSize = minSize;
                return this;
            }

            public ConfigDtoBuilder maxSize(Integer maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public ConfigDtoBuilder collectionInstance(Supplier<Collection<?>> collectionInstance) {
                this.collectionInstance = collectionInstance;
                return this;
            }

            public ConfigDtoBuilder elementGenerator(IGenerator<Object> elementGenerator) {
                this.elementGenerator = elementGenerator;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.minSize, this.maxSize, this.collectionInstance, this.elementGenerator, this.ruleRemark);
            }

            public String toString() {
                return "CollectionGenerator.ConfigDto.ConfigDtoBuilder(minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", collectionInstance=" + this.collectionInstance + ", elementGenerator=" + this.elementGenerator + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static class CollectionGeneratorBuilder<V>
    implements IGeneratorBuilderConfigurable {
        protected final ConfigDto configDto = new ConfigDto();

        public CollectionGeneratorBuilder<V> minSize(int minSize) {
            this.configDto.minSize = minSize;
            return this;
        }

        public CollectionGeneratorBuilder<V> maxSize(int maxSize) {
            this.configDto.maxSize = maxSize;
            return this;
        }

        public CollectionGeneratorBuilder<?> collectionInstance(Supplier<Collection<?>> listInstance) {
            this.configDto.collectionInstance = listInstance;
            return this;
        }

        public CollectionGeneratorBuilder<?> elementGenerator(IGenerator<?> itemGenerator) {
            this.configDto.elementGenerator = itemGenerator;
            return this;
        }

        public CollectionGeneratorBuilder<?> ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public CollectionGenerator build() {
            return this.build(this.configDto, false);
        }

        public CollectionGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto collectionConfig = (ConfigDto)configDto;
            return new CollectionGenerator(collectionConfig.minSize, collectionConfig.maxSize, (Collection)Objects.requireNonNull(collectionConfig.collectionInstance, "Collection instance must be set.").get(), Objects.requireNonNull(collectionConfig.elementGenerator, "Collection element generator must be set"), Objects.requireNonNull(collectionConfig.ruleRemark, "Unexpected error, rule remark haven't set."));
        }
    }
}

