/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGenerator;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGeneratorArgs;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGeneratorDtoDependent;
import org.laoruga.dtogenerator.api.rules.CustomRule;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGenerator
implements IGenerator<Object> {
    private final IGenerator<?> usersGeneratorInstance;

    public static CustomGeneratorBuilder builder() {
        return new CustomGeneratorBuilder();
    }

    @Override
    public Object generate() {
        return this.usersGeneratorInstance.generate();
    }

    public CustomGenerator(IGenerator<?> usersGeneratorInstance) {
        this.usersGeneratorInstance = usersGeneratorInstance;
    }

    public IGenerator<?> getUsersGeneratorInstance() {
        return this.usersGeneratorInstance;
    }

    public static class CustomGeneratorBuilder
    implements IGeneratorBuilder {
        private static final Logger log = LoggerFactory.getLogger(CustomGeneratorBuilder.class);
        private Supplier<?> dtoInstanceSupplier;
        private Annotation customGeneratorRules;

        public CustomGeneratorBuilder setDtoInstanceSupplier(Supplier<?> dtoInstanceSupplier) {
            this.dtoInstanceSupplier = dtoInstanceSupplier;
            return this;
        }

        public CustomGeneratorBuilder setCustomGeneratorRules(Annotation customGeneratorRules) {
            this.customGeneratorRules = customGeneratorRules;
            return this;
        }

        public CustomGenerator build() {
            return new CustomGenerator(this.createCustomGenerator());
        }

        IGenerator<?> createCustomGenerator() throws DtoGeneratorException {
            CustomRule customRules;
            try {
                customRules = (CustomRule)this.customGeneratorRules;
            }
            catch (ClassCastException e) {
                throw new DtoGeneratorException("Unexpected error. Unexpected annotation instead of: " + CustomRule.class, e);
            }
            Class<?> generatorClass = null;
            try {
                generatorClass = customRules.generatorClass();
                Object generatorInstance = ReflectionUtils.createInstance(generatorClass);
                if (generatorInstance instanceof ICustomGeneratorArgs) {
                    log.debug("Args {} have been obtained from Annotation: {}", Arrays.asList(customRules.args()), (Object)customRules);
                    ((ICustomGeneratorArgs)generatorInstance).setArgs(customRules.args());
                }
                if (generatorInstance instanceof ICustomGeneratorDtoDependent) {
                    this.setDto(generatorInstance);
                }
                if (generatorInstance instanceof ICustomGenerator) {
                    return (ICustomGenerator)generatorInstance;
                }
                throw new DtoGeneratorException("Failed to prepare custom generator. Custom generator must implements: '" + ICustomGenerator.class + "' or it's heirs.");
            }
            catch (Exception e) {
                throw new DtoGeneratorException("Error while preparing custom generator from class: " + generatorClass, e);
            }
        }

        private void setDto(Object generatorInstance) {
            try {
                ((ICustomGeneratorDtoDependent)generatorInstance).setDtoSupplier(this.dtoInstanceSupplier);
            }
            catch (ClassCastException e) {
                throw new DtoGeneratorException("ClassCastException while trying to set basic DTO into DTO dependent custom generator. Perhaps there is wrong argument type is passing into 'setDto' method of generator class. Generator class: '" + generatorInstance.getClass() + "', Passing argument type: '" + this.dtoInstanceSupplier.getClass() + "'", e);
            }
            catch (Exception e) {
                throw new DtoGeneratorException("Exception was thrown while trying to set DTO into DTO dependent custom generator: " + generatorInstance.getClass(), e);
            }
        }
    }
}

