/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import org.apache.commons.math3.util.Precision;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.DoubleRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.RandomUtils;

public class DoubleGenerator
implements IGenerator<Double> {
    private final double maxValue;
    private final double minValue;
    private final int precision;
    private final IRuleRemark ruleRemark;

    @Override
    public Double generate() {
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            return this.minValue;
        }
        if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            return this.maxValue;
        }
        if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            double generated = this.minValue + RandomUtils.getRandom().nextDouble() * (this.maxValue - this.minValue);
            return Precision.round((double)generated, (int)this.precision);
        }
        if (this.ruleRemark == RuleRemark.NULL_VALUE) {
            return null;
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public static DoubleGeneratorBuilder builder() {
        return new DoubleGeneratorBuilder();
    }

    public DoubleGenerator(double maxValue, double minValue, int precision, IRuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.precision = precision;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Double maxValue;
        private Double minValue;
        private Integer precision;
        private IRuleRemark ruleRemark;

        public ConfigDto() {
        }

        public ConfigDto(DoubleRule rule) {
            this.maxValue = rule.maxValue();
            this.minValue = rule.minValue();
            this.precision = rule.precision();
            this.ruleRemark = rule.ruleRemark();
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return DoubleGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto fromConfigDto = (ConfigDto)from;
            if (fromConfigDto.getMaxValue() != null) {
                this.maxValue = fromConfigDto.getMaxValue();
            }
            if (fromConfigDto.getMinValue() != null) {
                this.minValue = fromConfigDto.getMinValue();
            }
            if (fromConfigDto.getPrecision() != null) {
                this.precision = fromConfigDto.getPrecision();
            }
            if (fromConfigDto.getRuleRemark() != null) {
                this.ruleRemark = fromConfigDto.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public Double getMaxValue() {
            return this.maxValue;
        }

        public Double getMinValue() {
            return this.minValue;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        public void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        public void setPrecision(Integer precision) {
            this.precision = precision;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public ConfigDto(Double maxValue, Double minValue, Integer precision, IRuleRemark ruleRemark) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.precision = precision;
            this.ruleRemark = ruleRemark;
        }

        public static class ConfigDtoBuilder {
            private Double maxValue;
            private Double minValue;
            private Integer precision;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder maxValue(Double maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public ConfigDtoBuilder minValue(Double minValue) {
                this.minValue = minValue;
                return this;
            }

            public ConfigDtoBuilder precision(Integer precision) {
                this.precision = precision;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.maxValue, this.minValue, this.precision, this.ruleRemark);
            }

            public String toString() {
                return "DoubleGenerator.ConfigDto.ConfigDtoBuilder(maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", precision=" + this.precision + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static final class DoubleGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        private final ConfigDto configDto = new ConfigDto();

        private DoubleGeneratorBuilder() {
        }

        public DoubleGeneratorBuilder maxValue(double maxValue) {
            this.configDto.maxValue = maxValue;
            return this;
        }

        public DoubleGeneratorBuilder minValue(double minValue) {
            this.configDto.minValue = minValue;
            return this;
        }

        public DoubleGeneratorBuilder precision(int precision) {
            this.configDto.precision = precision;
            return this;
        }

        public DoubleGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public DoubleGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto doubleConfigDto = (ConfigDto)configDto;
            return new DoubleGenerator(doubleConfigDto.maxValue, doubleConfigDto.minValue, doubleConfigDto.precision, doubleConfigDto.ruleRemark);
        }

        public DoubleGenerator build() {
            return this.build(this.configDto, false);
        }
    }
}

