/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import java.util.Arrays;
import java.util.Comparator;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.RandomUtils;

public class EnumGenerator
implements IGenerator<Enum<?>> {
    private final String[] possibleEnumNames;
    private final Class<? extends Enum> enumClass;
    private final IRuleRemark ruleRemark;

    @Override
    public Enum<?> generate() {
        String enumInstanceName;
        String[] sortedEnumNames = (String[])Arrays.stream(this.possibleEnumNames).sorted(Comparator.comparing(String::length)).toArray(String[]::new);
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            enumInstanceName = sortedEnumNames[0];
        } else if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            enumInstanceName = sortedEnumNames[sortedEnumNames.length - 1];
        } else if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            int count = sortedEnumNames.length;
            enumInstanceName = sortedEnumNames[RandomUtils.getRandom().nextInt(count)];
        } else {
            if (this.ruleRemark == RuleRemark.NULL_VALUE) {
                return null;
            }
            throw new IllegalStateException("Unexpected value " + this.ruleRemark);
        }
        for (Enum enumConstant : this.enumClass.getEnumConstants()) {
            if (!enumConstant.name().equals(enumInstanceName)) continue;
            return enumConstant;
        }
        throw new DtoGeneratorException("Enum instance with name: '" + enumInstanceName + "' not found in Class: '" + this.enumClass + "'");
    }

    public static EnumGeneratorBuilder builder() {
        return new EnumGeneratorBuilder();
    }

    public EnumGenerator(String[] possibleEnumNames, Class<? extends Enum> enumClass, IRuleRemark ruleRemark) {
        this.possibleEnumNames = possibleEnumNames;
        this.enumClass = enumClass;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private String[] possibleEnumNames;
        private Class<? extends Enum> enumClass;
        private IRuleRemark ruleRemark;

        public ConfigDto(EnumRule enumRule) {
            this.possibleEnumNames = enumRule.possibleEnumNames();
            this.ruleRemark = enumRule.ruleRemark();
        }

        public ConfigDto() {
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return EnumGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto configDto = (ConfigDto)from;
            if (configDto.getPossibleEnumNames() != null) {
                this.possibleEnumNames = configDto.getPossibleEnumNames();
            }
            if (configDto.getEnumClass() != null) {
                this.enumClass = configDto.getEnumClass();
            }
            if (configDto.getRuleRemark() != null) {
                this.ruleRemark = configDto.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public String[] getPossibleEnumNames() {
            return this.possibleEnumNames;
        }

        public Class<? extends Enum> getEnumClass() {
            return this.enumClass;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public void setPossibleEnumNames(String[] possibleEnumNames) {
            this.possibleEnumNames = possibleEnumNames;
        }

        public void setEnumClass(Class<? extends Enum> enumClass) {
            this.enumClass = enumClass;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public ConfigDto(String[] possibleEnumNames, Class<? extends Enum> enumClass, IRuleRemark ruleRemark) {
            this.possibleEnumNames = possibleEnumNames;
            this.enumClass = enumClass;
            this.ruleRemark = ruleRemark;
        }

        static /* synthetic */ String[] access$102(ConfigDto x0, String[] x1) {
            x0.possibleEnumNames = x1;
            return x1;
        }

        public static class ConfigDtoBuilder {
            private String[] possibleEnumNames;
            private Class<? extends Enum> enumClass;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder possibleEnumNames(String[] possibleEnumNames) {
                this.possibleEnumNames = possibleEnumNames;
                return this;
            }

            public ConfigDtoBuilder enumClass(Class<? extends Enum> enumClass) {
                this.enumClass = enumClass;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.possibleEnumNames, this.enumClass, this.ruleRemark);
            }

            public String toString() {
                return "EnumGenerator.ConfigDto.ConfigDtoBuilder(possibleEnumNames=" + Arrays.deepToString(this.possibleEnumNames) + ", enumClass=" + this.enumClass + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static final class EnumGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        ConfigDto configDto = new ConfigDto();

        private EnumGeneratorBuilder() {
        }

        public EnumGeneratorBuilder possibleEnumNames(String ... possibleEnumNames) {
            ConfigDto.access$102(this.configDto, possibleEnumNames);
            return this;
        }

        public EnumGeneratorBuilder enumClass(Class<?> enumClass) {
            if (!enumClass.isEnum()) {
                throw new DtoGeneratorException(new ClassCastException("Enum class expected"));
            }
            this.configDto.enumClass = enumClass;
            return this;
        }

        public EnumGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public EnumGenerator build() {
            return this.build(this.configDto, false);
        }

        public EnumGenerator build(IConfigDto configDto, boolean merge) {
            ConfigDto enumConfigDto;
            if (merge) {
                configDto.merge(this.configDto);
            }
            if ((enumConfigDto = (ConfigDto)configDto).enumClass == null) {
                throw new DtoGeneratorException("Enum class wasn't set for generator.");
            }
            if (enumConfigDto.possibleEnumNames.length == 0) {
                ConfigDto.access$102(enumConfigDto, (String[])Arrays.stream(enumConfigDto.enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new));
            }
            return new EnumGenerator(enumConfigDto.possibleEnumNames, enumConfigDto.enumClass, enumConfigDto.ruleRemark);
        }
    }
}

