/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.IntegerRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.RandomUtils;

public class IntegerGenerator
implements IGenerator<Integer> {
    private final int maxValue;
    private final int minValue;
    private final IRuleRemark ruleRemark;

    @Override
    public Integer generate() {
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            return this.minValue;
        }
        if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            return this.maxValue;
        }
        if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            return RandomUtils.nextInt(this.minValue, this.maxValue);
        }
        if (this.ruleRemark == RuleRemark.NULL_VALUE) {
            return null;
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public static IntegerGeneratorBuilder builder() {
        return new IntegerGeneratorBuilder();
    }

    public IntegerGenerator(int maxValue, int minValue, IRuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Integer maxValue;
        private Integer minValue;
        private IRuleRemark ruleRemark;

        public ConfigDto(IntegerRule rule) {
            this.maxValue = rule.maxValue();
            this.minValue = rule.minValue();
            this.ruleRemark = rule.ruleRemark();
        }

        public ConfigDto() {
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return IntegerGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto configDto = (ConfigDto)from;
            if (configDto.getMaxValue() != null) {
                this.maxValue = configDto.getMaxValue();
            }
            if (configDto.getMinValue() != null) {
                this.minValue = configDto.getMinValue();
            }
            if (configDto.getRuleRemark() != null) {
                this.ruleRemark = configDto.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public Integer getMaxValue() {
            return this.maxValue;
        }

        public Integer getMinValue() {
            return this.minValue;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        public void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public ConfigDto(Integer maxValue, Integer minValue, IRuleRemark ruleRemark) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.ruleRemark = ruleRemark;
        }

        public static class ConfigDtoBuilder {
            private Integer maxValue;
            private Integer minValue;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder maxValue(Integer maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            public ConfigDtoBuilder minValue(Integer minValue) {
                this.minValue = minValue;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.maxValue, this.minValue, this.ruleRemark);
            }

            public String toString() {
                return "IntegerGenerator.ConfigDto.ConfigDtoBuilder(maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static final class IntegerGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        private final ConfigDto configDto = new ConfigDto();

        private IntegerGeneratorBuilder() {
        }

        public IntegerGeneratorBuilder maxValue(int maxValue) {
            this.configDto.maxValue = maxValue;
            return this;
        }

        public IntegerGeneratorBuilder minValue(int minValue) {
            this.configDto.minValue = minValue;
            return this;
        }

        public IntegerGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public IntegerGenerator build() {
            return this.build(this.configDto, false);
        }

        public IntegerGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto integerConfigDto = (ConfigDto)configDto;
            return new IntegerGenerator(integerConfigDto.maxValue, integerConfigDto.minValue, integerConfigDto.ruleRemark);
        }
    }
}

