/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators;

import java.time.LocalDateTime;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilderConfigurable;
import org.laoruga.dtogenerator.api.remarks.IRuleRemark;
import org.laoruga.dtogenerator.api.rules.LocalDateTimeRule;
import org.laoruga.dtogenerator.constants.RuleRemark;
import org.laoruga.dtogenerator.typegenerators.IConfigDto;
import org.laoruga.dtogenerator.util.RandomUtils;

public class LocalDateTimeGenerator
implements IGenerator<LocalDateTime> {
    private final int leftShiftDays;
    private final int rightShiftDays;
    private final IRuleRemark ruleRemark;

    @Override
    public LocalDateTime generate() {
        LocalDateTime now = LocalDateTime.now();
        if (this.ruleRemark == RuleRemark.MIN_VALUE) {
            return now.minusDays(this.leftShiftDays);
        }
        if (this.ruleRemark == RuleRemark.MAX_VALUE) {
            return now.plusDays(this.rightShiftDays);
        }
        if (this.ruleRemark == RuleRemark.RANDOM_VALUE) {
            int randomInt = RandomUtils.getRandom().nextInt(this.leftShiftDays + this.rightShiftDays + 1);
            LocalDateTime minDate = now.minusDays(this.leftShiftDays);
            return minDate.plusDays(randomInt);
        }
        if (this.ruleRemark == RuleRemark.NULL_VALUE) {
            return null;
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public static LocalDateTimeGeneratorBuilder builder() {
        return new LocalDateTimeGeneratorBuilder();
    }

    public LocalDateTimeGenerator(int leftShiftDays, int rightShiftDays, IRuleRemark ruleRemark) {
        this.leftShiftDays = leftShiftDays;
        this.rightShiftDays = rightShiftDays;
        this.ruleRemark = ruleRemark;
    }

    public static class ConfigDto
    implements IConfigDto {
        private Integer leftShiftDays;
        private Integer rightShiftDays;
        private IRuleRemark ruleRemark;

        public ConfigDto(LocalDateTimeRule rule) {
            this.leftShiftDays = rule.leftShiftDays();
            this.rightShiftDays = rule.rightShiftDays();
            this.ruleRemark = rule.ruleRemark();
        }

        public ConfigDto() {
        }

        @Override
        public Class<? extends IGeneratorBuilder> getBuilderClass() {
            return LocalDateTimeGeneratorBuilder.class;
        }

        @Override
        public void merge(IConfigDto from) {
            ConfigDto configDto = (ConfigDto)from;
            if (configDto.getLeftShiftDays() != null) {
                this.leftShiftDays = configDto.getLeftShiftDays();
            }
            if (configDto.getRightShiftDays() != null) {
                this.rightShiftDays = configDto.getRightShiftDays();
            }
            if (configDto.getRuleRemark() != null) {
                this.ruleRemark = configDto.getRuleRemark();
            }
        }

        public static ConfigDtoBuilder builder() {
            return new ConfigDtoBuilder();
        }

        public Integer getLeftShiftDays() {
            return this.leftShiftDays;
        }

        public Integer getRightShiftDays() {
            return this.rightShiftDays;
        }

        @Override
        public IRuleRemark getRuleRemark() {
            return this.ruleRemark;
        }

        public void setLeftShiftDays(Integer leftShiftDays) {
            this.leftShiftDays = leftShiftDays;
        }

        public void setRightShiftDays(Integer rightShiftDays) {
            this.rightShiftDays = rightShiftDays;
        }

        public ConfigDto(Integer leftShiftDays, Integer rightShiftDays, IRuleRemark ruleRemark) {
            this.leftShiftDays = leftShiftDays;
            this.rightShiftDays = rightShiftDays;
            this.ruleRemark = ruleRemark;
        }

        @Override
        public void setRuleRemark(IRuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
        }

        public static class ConfigDtoBuilder {
            private Integer leftShiftDays;
            private Integer rightShiftDays;
            private IRuleRemark ruleRemark;

            ConfigDtoBuilder() {
            }

            public ConfigDtoBuilder leftShiftDays(Integer leftShiftDays) {
                this.leftShiftDays = leftShiftDays;
                return this;
            }

            public ConfigDtoBuilder rightShiftDays(Integer rightShiftDays) {
                this.rightShiftDays = rightShiftDays;
                return this;
            }

            public ConfigDtoBuilder ruleRemark(IRuleRemark ruleRemark) {
                this.ruleRemark = ruleRemark;
                return this;
            }

            public ConfigDto build() {
                return new ConfigDto(this.leftShiftDays, this.rightShiftDays, this.ruleRemark);
            }

            public String toString() {
                return "LocalDateTimeGenerator.ConfigDto.ConfigDtoBuilder(leftShiftDays=" + this.leftShiftDays + ", rightShiftDays=" + this.rightShiftDays + ", ruleRemark=" + this.ruleRemark + ")";
            }
        }
    }

    public static final class LocalDateTimeGeneratorBuilder
    implements IGeneratorBuilderConfigurable {
        private final ConfigDto configDto = new ConfigDto();

        private LocalDateTimeGeneratorBuilder() {
        }

        public LocalDateTimeGeneratorBuilder leftShiftDays(int leftShiftDays) {
            this.configDto.leftShiftDays = leftShiftDays;
            return this;
        }

        public LocalDateTimeGeneratorBuilder rightShiftDays(int rightShiftDays) {
            this.configDto.rightShiftDays = rightShiftDays;
            return this;
        }

        public LocalDateTimeGeneratorBuilder ruleRemark(IRuleRemark ruleRemark) {
            this.configDto.ruleRemark = ruleRemark;
            return this;
        }

        public LocalDateTimeGenerator build() {
            return this.build(this.configDto, false);
        }

        public LocalDateTimeGenerator build(IConfigDto configDto, boolean merge) {
            if (merge) {
                configDto.merge(this.configDto);
            }
            ConfigDto localDateTimeConfigDto = (ConfigDto)configDto;
            return new LocalDateTimeGenerator(localDateTimeConfigDto.leftShiftDays, localDateTimeConfigDto.rightShiftDays, localDateTimeConfigDto.ruleRemark);
        }
    }
}

