/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.builders;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.IGeneratorBuilder;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public final class GeneratorBuildersHolder {
    private final List<GenBuilderInfo> builderInfoList;

    public Optional<IGeneratorBuilder> getBuilder(Class<?> generatedType) {
        if (generatedType.isEnum()) {
            return this.getEnumBuilder(generatedType);
        }
        IGeneratorBuilder matchedBuilder = null;
        for (GenBuilderInfo info : this.getBuilderInfoList()) {
            Class<?> buildersGeneratedType = info.getGeneratedType();
            if (buildersGeneratedType != generatedType) continue;
            if (matchedBuilder != null) {
                throw new DtoGeneratorException("More than one matched generators found for generated type: '" + generatedType + "'");
            }
            matchedBuilder = info.getBuilderSupplier().get();
        }
        return matchedBuilder != null ? Optional.of(matchedBuilder) : Optional.empty();
    }

    private Optional<IGeneratorBuilder> getEnumBuilder(Class<?> generatedType) {
        IGeneratorBuilder anyEnumBuilder = null;
        IGeneratorBuilder strictEnumBuilder = null;
        for (GenBuilderInfo info : this.getBuilderInfoList()) {
            if (info.getGeneratedType() == Enum.class) {
                if (anyEnumBuilder != null) {
                    GeneratorBuildersHolder.throwError(generatedType);
                }
                anyEnumBuilder = info.getBuilderSupplier().get();
                continue;
            }
            if (info.getGeneratedType() != generatedType) continue;
            if (strictEnumBuilder != null) {
                GeneratorBuildersHolder.throwError(generatedType);
            }
            strictEnumBuilder = info.getBuilderSupplier().get();
        }
        return Optional.ofNullable(anyEnumBuilder != null ? anyEnumBuilder : strictEnumBuilder);
    }

    private static void throwError(Class<?> generatedType) {
        throw new DtoGeneratorException("More than one matched generators found for generated type: '" + generatedType + "'");
    }

    public Optional<IGeneratorBuilder> getBuilder(Annotation rulesAnnotation, Class<?> generatedType) {
        GenBuilderInfo matchedBuilder = null;
        for (GenBuilderInfo info : this.getBuilderInfoList()) {
            if (info.getRules() != rulesAnnotation.annotationType()) continue;
            if (matchedBuilder != null) {
                throw new DtoGeneratorException("More than one matched generators found for rules: '" + rulesAnnotation + "'");
            }
            matchedBuilder = info;
        }
        if (matchedBuilder == null) {
            return Optional.empty();
        }
        Class<?> buildersGeneratedType = matchedBuilder.getGeneratedType();
        if (buildersGeneratedType == generatedType || buildersGeneratedType.isAssignableFrom(generatedType) || generatedType.isPrimitive() && generatedType == matchedBuilder.getGeneratedTypePrimitive()) {
            return Optional.of(matchedBuilder.builderSupplier.get());
        }
        throw new DtoGeneratorException("For rules: '" + rulesAnnotation + "' builder's generated type: '" + buildersGeneratedType + "' not matched to field type: " + generatedType + "'.");
    }

    public void addBuilder(Class<? extends Annotation> rulesClass, Class<?> generatedType, IGeneratorBuilder genBuilder) {
        this.getBuilderInfoList().add(GenBuilderInfo.createInstance(rulesClass, generatedType, () -> genBuilder));
    }

    public GeneratorBuildersHolder(List<GenBuilderInfo> builderInfoList) {
        this.builderInfoList = builderInfoList;
    }

    private List<GenBuilderInfo> getBuilderInfoList() {
        return this.builderInfoList;
    }

    static class GenBuilderInfo {
        private Class<? extends Annotation> rules;
        private Class<?> generatedType;
        private Class<?> generatedTypePrimitive;
        private Supplier<IGeneratorBuilder> builderSupplier;

        GenBuilderInfo() {
        }

        public static GenBuilderInfo createInstance(Class<? extends Annotation> rules, Class<?> generatedType, Supplier<IGeneratorBuilder> builderSupplier) {
            return GenBuilderInfo.createInstance(rules, generatedType, null, builderSupplier);
        }

        public static GenBuilderInfo createInstance(Class<? extends Annotation> rules, Class<?> generatedType, Class<?> generatedTypePrimitive, Supplier<IGeneratorBuilder> builderSupplier) {
            GenBuilderInfo genBuilderInfo = new GenBuilderInfo();
            genBuilderInfo.rules = rules;
            genBuilderInfo.generatedType = generatedType;
            genBuilderInfo.generatedTypePrimitive = generatedTypePrimitive;
            genBuilderInfo.builderSupplier = builderSupplier;
            return genBuilderInfo;
        }

        public Class<? extends Annotation> getRules() {
            return this.rules;
        }

        public Class<?> getGeneratedType() {
            return this.generatedType;
        }

        public Class<?> getGeneratedTypePrimitive() {
            return this.generatedTypePrimitive;
        }

        public Supplier<IGeneratorBuilder> getBuilderSupplier() {
            return this.builderSupplier;
        }
    }
}

