/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.executors;

import java.lang.reflect.Field;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.api.generators.custom.ICustomGeneratorDtoDependent;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.CustomGenerator;
import org.laoruga.dtogenerator.typegenerators.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorOfDtoDependentGenerator
extends AbstractExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOfDtoDependentGenerator.class);

    public ExecutorOfDtoDependentGenerator(AbstractExecutor nextGenerators) {
        super(nextGenerators);
    }

    @Override
    public boolean execute(Field field, IGenerator<?> generator) {
        if (!this.isDtoReadyForFieldGeneration(generator)) {
            return false;
        }
        return this.executeNext(field, generator);
    }

    protected boolean isDtoReadyForFieldGeneration(IGenerator<?> generator) throws DtoGeneratorException {
        IGenerator<?> usersGeneratorInstance;
        if (generator instanceof CustomGenerator && (usersGeneratorInstance = ((CustomGenerator)generator).getUsersGeneratorInstance()) instanceof ICustomGeneratorDtoDependent) {
            boolean dtoReady = ((ICustomGeneratorDtoDependent)usersGeneratorInstance).isDtoReady();
            log.debug("Object {} ready to generate dependent field value", (Object)(dtoReady ? "is" : "isn't"));
            return dtoReady;
        }
        return true;
    }
}

