/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.typegenerators.executors;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.IGenerator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.typegenerators.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorOfGenerator
extends AbstractExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOfGenerator.class);
    private final Supplier<?> dtoInstanceSupplier;

    public <T> ExecutorOfGenerator(Supplier<?> dtoInstanceSupplier) {
        super(null);
        this.dtoInstanceSupplier = dtoInstanceSupplier;
    }

    @Override
    public boolean execute(Field field, IGenerator<?> generator) {
        Object result;
        try {
            result = generator.generate();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while generating value for the field: " + field, e);
        }
        try {
            field.setAccessible(true);
            field.set(this.dtoInstanceSupplier.get(), result);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while setting generated value of type: '" + (result != null ? result.getClass() : null) + "' to the field: '" + field + "'", e);
        }
        return true;
    }
}

